/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.psi.impl.PyFileImpl;
import com.jetbrains.python.validation.AssignTargetAnnotator;
import com.jetbrains.python.validation.BreakContinueAnnotator;
import com.jetbrains.python.validation.GlobalAnnotator;
import com.jetbrains.python.validation.HighlightingAnnotator;
import com.jetbrains.python.validation.ImportAnnotator;
import com.jetbrains.python.validation.ParameterListAnnotator;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.PyBuiltinAnnotator;
import com.jetbrains.python.validation.ReturnAnnotator;
import com.jetbrains.python.validation.TryExceptAnnotator;
import com.jetbrains.python.validation.UnsupportedFeatures;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class PyAnnotatingVisitor
implements Annotator {
    private static final Logger LOGGER = Logger.getInstance((String)PyAnnotatingVisitor.class.getName());
    private static final Class[] ANNOTATOR_CLASSES = new Class[]{AssignTargetAnnotator.class, ParameterListAnnotator.class, HighlightingAnnotator.class, ReturnAnnotator.class, TryExceptAnnotator.class, BreakContinueAnnotator.class, GlobalAnnotator.class, ImportAnnotator.class, PyBuiltinAnnotator.class, UnsupportedFeatures.class};
    private final PyAnnotator[] myAnnotators;

    public PyAnnotatingVisitor() {
        ArrayList<PyAnnotator> annotators = new ArrayList<PyAnnotator>();
        for (Class cls : ANNOTATOR_CLASSES) {
            PyAnnotator annotator;
            try {
                annotator = (PyAnnotator)((Object)cls.newInstance());
            }
            catch (InstantiationException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                LOGGER.error((Throwable)e);
                continue;
            }
            annotators.add(annotator);
        }
        this.myAnnotators = annotators.toArray(new PyAnnotator[annotators.size()]);
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/jetbrains/python/validation/PyAnnotatingVisitor", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/validation/PyAnnotatingVisitor", "annotate"));
        }
        PsiFile file = psiElement.getContainingFile();
        for (PyAnnotator annotator : this.myAnnotators) {
            if (file instanceof PyFileImpl && !((PyFileImpl)file).isAcceptedFor(((Object)((Object)annotator)).getClass())) continue;
            annotator.annotateElement(psiElement, holder);
        }
    }
}

