/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.ImmutableMap;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ModifiableModel;
import com.intellij.codeInspection.ex.CustomEditInspectionToolsSettingsAction;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.codeInsight.imports.OptimizeImportsQuickFix;
import com.jetbrains.python.inspections.PyPep8Inspection;
import com.jetbrains.python.inspections.quickfix.ReformatFix;
import com.jetbrains.python.quickFixes.RemoveTrailingBlankLinesFix;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pep8ExternalAnnotator
extends ExternalAnnotator<State, Results> {
    private static final Logger LOG = Logger.getInstance(Pep8ExternalAnnotator.class);
    private boolean myReportedMissingInterpreter;
    private static final Pattern PROBLEM_PATTERN = Pattern.compile(".+:(\\d+):(\\d+): ([EW]\\d{3}) (.+)");

    @Nullable
    public State collectInformation(@NotNull PsiFile file) {
        HighlightDisplayKey key;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/validation/Pep8ExternalAnnotator", "collectInformation"));
        }
        VirtualFile vFile = file.getVirtualFile();
        if (vFile == null || vFile.getFileType() != PythonFileType.INSTANCE) {
            return null;
        }
        Sdk sdk = PythonSdkType.findLocalCPython(ModuleUtilCore.findModuleForPsiElement((PsiElement)file));
        if (sdk == null) {
            if (!this.myReportedMissingInterpreter) {
                this.myReportedMissingInterpreter = true;
                Pep8ExternalAnnotator.reportMissingInterpreter();
            }
            return null;
        }
        String homePath = sdk.getHomePath();
        if (homePath == null) {
            if (!this.myReportedMissingInterpreter) {
                this.myReportedMissingInterpreter = true;
                LOG.info("Could not find home path for interpreter " + homePath);
            }
            return null;
        }
        InspectionProfile profile = InspectionProjectProfileManager.getInstance(file.getProject()).getInspectionProfile();
        if (!profile.isToolEnabled(key = HighlightDisplayKey.find((String)"PyPep8Inspection"))) {
            return null;
        }
        PyPep8Inspection inspection = (PyPep8Inspection)profile.getUnwrappedTool(PyPep8Inspection.KEY.toString(), (PsiElement)file);
        List<String> ignoredErrors = inspection.ignoredErrors;
        int margin = CodeStyleSettingsManager.getInstance((Project)file.getProject()).getCurrentSettings().getRightMargin(file.getLanguage());
        return new State(homePath, file.getText(), profile.getErrorLevel(key, (PsiElement)file), ignoredErrors, margin);
    }

    private static void reportMissingInterpreter() {
        LOG.info("Found no suitable interpreter to run pep.py. Available interpreters are: [");
        List<Sdk> allSdks = PythonSdkType.getAllSdks();
        Collections.sort(allSdks, PreferredSdkComparator.INSTANCE);
        for (Sdk sdk : allSdks) {
            LOG.info("  Path: " + sdk.getHomePath() + "; Flavor: " + PythonSdkFlavor.getFlavor(sdk) + "; Remote: " + PythonSdkType.isRemote(sdk));
        }
        LOG.info("]");
    }

    @Nullable
    public Results doAnnotate(State collectedInfo) {
        if (collectedInfo == null) {
            return null;
        }
        String pep8Path = PythonHelpersLocator.getHelperPath("pep8.py");
        ArrayList<String> options = new ArrayList<String>();
        Collections.addAll(options, collectedInfo.interpreterPath, pep8Path);
        if (collectedInfo.ignoredErrors.size() > 0) {
            options.add("--ignore=" + StringUtil.join((Collection)collectedInfo.ignoredErrors, (String)","));
        }
        options.add("--max-line-length=" + collectedInfo.margin);
        options.add("-");
        ProcessOutput output = PySdkUtil.getProcessOutput(new File(collectedInfo.interpreterPath).getParent(), ArrayUtil.toStringArray(options), (Map<String, String>)ImmutableMap.of((Object)"PYTHONBUFFERED", (Object)"1"), 10000, collectedInfo.fileText.getBytes(), false);
        Results results = new Results(collectedInfo.level);
        if (output.isTimeout()) {
            LOG.info("Timeout running pep8.py");
        } else if (output.getStderrLines().isEmpty()) {
            for (String line : output.getStdoutLines()) {
                Problem problem = Pep8ExternalAnnotator.parseProblem(line);
                if (problem == null) continue;
                results.problems.add(problem);
            }
        } else if (((ApplicationInfoImpl)ApplicationInfo.getInstance()).isEAP()) {
            LOG.info("Error running pep8.py: " + output.getStderr());
        }
        return results;
    }

    public void apply(@NotNull PsiFile file, Results annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/validation/Pep8ExternalAnnotator", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/python/validation/Pep8ExternalAnnotator", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        if (!file.isValid()) {
            LOG.info("Trying to apply diagnostics to invalid PsiFile, skipped");
            return;
        }
        String text = file.getText();
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        for (Problem problem : annotationResult.problems) {
            PsiElement elementAfter;
            if (Pep8ExternalAnnotator.ignoreDueToSettings(project, problem)) continue;
            int line = problem.myLine - 1;
            int column = problem.myColumn - 1;
            int offset = document != null ? (line >= document.getLineCount() ? document.getTextLength() - 1 : document.getLineStartOffset(line) + column) : StringUtil.lineColToOffset((CharSequence)text, (int)line, (int)column);
            PsiElement problemElement = file.findElementAt(offset);
            if (!(problemElement instanceof PsiWhiteSpace) && !problem.myCode.startsWith("E3") && (elementAfter = file.findElementAt(offset + 1)) instanceof PsiWhiteSpace) {
                problemElement = elementAfter;
            }
            if (problemElement == null) continue;
            TextRange problemRange = problemElement.getTextRange();
            if (Pep8ExternalAnnotator.crossesLineBoundary(document, text, problemRange)) {
                int lineEndOffset = document != null ? (line >= document.getLineCount() ? document.getTextLength() - 1 : document.getLineEndOffset(line)) : StringUtil.lineColToOffset((CharSequence)text, (int)(line + 1), (int)0) - 1;
                if (offset > lineEndOffset) continue;
                problemRange = new TextRange(offset, lineEndOffset);
            }
            String message = "PEP 8: " + problem.myDescription;
            Annotation annotation = annotationResult.level == HighlightDisplayLevel.ERROR ? holder.createErrorAnnotation(problemRange, message) : (annotationResult.level == HighlightDisplayLevel.WARNING ? holder.createWarningAnnotation(problemRange, message) : holder.createWeakWarningAnnotation(problemRange, message));
            if (problem.myCode.equals("E401")) {
                annotation.registerUniversalFix((IntentionAction)new OptimizeImportsQuickFix(), null, null);
            } else if (problem.myCode.equals("W391")) {
                annotation.registerUniversalFix((IntentionAction)new RemoveTrailingBlankLinesFix(), null, null);
            } else {
                annotation.registerUniversalFix((IntentionAction)new ReformatFix(), null, null);
            }
            annotation.registerFix((IntentionAction)new IgnoreErrorFix(problem.myCode));
            annotation.registerFix((IntentionAction)new CustomEditInspectionToolsSettingsAction(HighlightDisplayKey.find((String)"PyPep8Inspection"), new Computable<String>(){

                public String compute() {
                    return "Edit inspection profile setting";
                }
            }));
        }
    }

    private static boolean crossesLineBoundary(@Nullable Document document, String text, TextRange problemRange) {
        int start = problemRange.getStartOffset();
        int end = problemRange.getEndOffset();
        if (document != null) {
            return document.getLineNumber(start) != document.getLineNumber(end);
        }
        return StringUtil.offsetToLineNumber((CharSequence)text, (int)start) != StringUtil.offsetToLineNumber((CharSequence)text, (int)end);
    }

    private static boolean ignoreDueToSettings(Project project, Problem problem) {
        String stripTrailingSpaces = EditorSettingsExternalizable.getInstance().getStripTrailingSpaces();
        if (!stripTrailingSpaces.equals("None") && (problem.myCode.equals("W291") || problem.myCode.equals("W293"))) {
            return true;
        }
        boolean useTabs = CodeStyleSettingsManager.getSettings((Project)project).useTabCharacter((FileType)PythonFileType.INSTANCE);
        return useTabs && problem.myCode.equals("W191");
    }

    @Nullable
    private static Problem parseProblem(String s) {
        Matcher m = PROBLEM_PATTERN.matcher(s);
        if (m.matches()) {
            int line = Integer.parseInt(m.group(1));
            int column = Integer.parseInt(m.group(2));
            return new Problem(line, column, m.group(3), m.group(4));
        }
        if (((ApplicationInfoImpl)ApplicationInfo.getInstance()).isEAP()) {
            LOG.info("Failed to parse problem line from pep8.py: " + s);
        }
        return null;
    }

    private static class IgnoreErrorFix
    implements IntentionAction {
        private final String myCode;

        public IgnoreErrorFix(String code) {
            this.myCode = code;
        }

        @NotNull
        public String getText() {
            if ("Ignore errors like this" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix", "getText"));
            }
            return "Ignore errors like this";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix", "getFamilyName"));
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix", "isAvailable"));
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, final PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/validation/Pep8ExternalAnnotator$IgnoreErrorFix", "invoke"));
            }
            InspectionProjectProfileManager.getInstance(project).getInspectionProfile((PsiElement)file).modifyProfile((Consumer)new Consumer<ModifiableModel>(){

                public void consume(ModifiableModel model) {
                    PyPep8Inspection tool = (PyPep8Inspection)model.getUnwrappedTool("PyPep8Inspection", (PsiElement)file);
                    tool.ignoredErrors.add(IgnoreErrorFix.this.myCode);
                }
            });
        }

        public boolean startInWriteAction() {
            return false;
        }
    }

    public static class Results {
        public final List<Problem> problems = new ArrayList<Problem>();
        private final HighlightDisplayLevel level;

        public Results(HighlightDisplayLevel level) {
            this.level = level;
        }
    }

    public static class State {
        private final String interpreterPath;
        private final String fileText;
        private final HighlightDisplayLevel level;
        private final List<String> ignoredErrors;
        private final int margin;

        public State(String interpreterPath, String fileText, HighlightDisplayLevel level, List<String> ignoredErrors, int margin) {
            this.interpreterPath = interpreterPath;
            this.fileText = fileText;
            this.level = level;
            this.ignoredErrors = ignoredErrors;
            this.margin = margin;
        }
    }

    public static class Problem {
        private final int myLine;
        private final int myColumn;
        private final String myCode;
        private final String myDescription;

        public Problem(int line, int column, String code, String description) {
            this.myLine = line;
            this.myColumn = column;
            this.myCode = code;
            this.myDescription = description;
        }
    }
}

