/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PySingleStarParameter;
import com.jetbrains.python.psi.PyTupleParameter;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.validation.PyAnnotator;
import java.util.Set;

public class ParameterListAnnotator
extends PyAnnotator {
    @Override
    public void visitPyParameterList(PyParameterList paramlist) {
        final LanguageLevel languageLevel = ((PyFile)paramlist.getContainingFile()).getLanguageLevel();
        ParamHelper.walkDownParamArray(paramlist.getParameters(), new ParamHelper.ParamVisitor(){
            Set<String> parameterNames = new HashSet();
            boolean hadPositionalContainer = false;
            boolean hadKeywordContainer = false;
            boolean hadDefaultValue = false;
            boolean hadSingleStar = false;
            boolean hadParamsAfterSingleStar = false;
            int inTuple = 0;

            @Override
            public void visitNamedParameter(PyNamedParameter parameter, boolean first, boolean last) {
                if (this.parameterNames.contains(parameter.getName())) {
                    ParameterListAnnotator.this.markError((PsiElement)parameter, PyBundle.message("ANN.duplicate.param.name", new Object[0]));
                }
                this.parameterNames.add(parameter.getName());
                if (parameter.isPositionalContainer()) {
                    if (this.hadKeywordContainer) {
                        ParameterListAnnotator.this.markError((PsiElement)parameter, PyBundle.message("ANN.starred.param.after.kwparam", new Object[0]));
                    }
                    if (this.hadSingleStar) {
                        ParameterListAnnotator.this.markError((PsiElement)parameter, "Multiple * arguments are not allowed");
                    }
                    this.hadPositionalContainer = true;
                } else if (parameter.isKeywordContainer()) {
                    this.hadKeywordContainer = true;
                    if (this.hadSingleStar && !this.hadParamsAfterSingleStar) {
                        ParameterListAnnotator.this.markError((PsiElement)parameter, PyBundle.message("ANN.named.arguments.after.star", new Object[0]));
                    }
                } else {
                    if (this.hadSingleStar) {
                        this.hadParamsAfterSingleStar = true;
                    }
                    if (this.hadPositionalContainer && !languageLevel.isPy3K()) {
                        ParameterListAnnotator.this.markError((PsiElement)parameter, PyBundle.message("ANN.regular.param.after.vararg", new Object[0]));
                    } else if (this.hadKeywordContainer) {
                        ParameterListAnnotator.this.markError((PsiElement)parameter, PyBundle.message("ANN.regular.param.after.keyword", new Object[0]));
                    }
                    if (parameter.hasDefaultValue()) {
                        this.hadDefaultValue = true;
                    } else if (!(!this.hadDefaultValue || this.hadSingleStar || languageLevel.isPy3K() && this.hadPositionalContainer || this.inTuple != 0)) {
                        ParameterListAnnotator.this.markError((PsiElement)parameter, PyBundle.message("ANN.non.default.param.after.default", new Object[0]));
                    }
                }
            }

            @Override
            public void enterTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                ++this.inTuple;
                if (languageLevel.isPy3K()) {
                    ParameterListAnnotator.this.markError((PsiElement)param, PyBundle.message("ANN.tuple.py3", new Object[0]));
                } else if (!param.hasDefaultValue() && this.hadDefaultValue) {
                    ParameterListAnnotator.this.markError((PsiElement)param, PyBundle.message("ANN.non.default.param.after.default", new Object[0]));
                }
            }

            @Override
            public void leaveTupleParameter(PyTupleParameter param, boolean first, boolean last) {
                --this.inTuple;
            }

            @Override
            public void visitSingleStarParameter(PySingleStarParameter param, boolean first, boolean last) {
                if (this.hadPositionalContainer || this.hadSingleStar) {
                    ParameterListAnnotator.this.markError((PsiElement)param, "Multiple * arguments are not allowed");
                }
                this.hadSingleStar = true;
                if (last) {
                    ParameterListAnnotator.this.markError((PsiElement)param, PyBundle.message("ANN.named.arguments.after.star", new Object[0]));
                }
            }
        });
    }
}

