/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.validation.PyAnnotator;

public class HighlightingAnnotator
extends PyAnnotator {
    @Override
    public void visitPyParameter(PyParameter node) {
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class);
        if (function != null) {
            Annotation annotation = this.getHolder().createInfoAnnotation((PsiElement)node, null);
            annotation.setTextAttributes(node.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER);
        }
    }

    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        PyNamedParameter element;
        PyFunction function;
        String referencedName = node.getReferencedName();
        if (!node.isQualified() && referencedName != null && (function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class)) != null && (element = function.getParameterList().findParameterByName(referencedName)) != null) {
            Annotation annotation = this.getHolder().createInfoAnnotation((PsiElement)node, null);
            annotation.setTextAttributes(element.isSelf() ? PyHighlighter.PY_SELF_PARAMETER : PyHighlighter.PY_PARAMETER);
        }
    }

    @Override
    public void visitPyKeywordArgument(PyKeywordArgument node) {
        ASTNode keywordNode = node.getKeywordNode();
        if (keywordNode != null) {
            Annotation annotation = this.getHolder().createInfoAnnotation(keywordNode, null);
            annotation.setTextAttributes(PyHighlighter.PY_KEYWORD_ARGUMENT);
        }
    }
}

