/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.documentation.DocStringReferenceProvider;
import com.jetbrains.python.documentation.DocStringUtil;
import com.jetbrains.python.documentation.EpydocString;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.documentation.SphinxDocString;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.validation.PyAnnotator;

public class DocStringAnnotator
extends PyAnnotator {
    @Override
    public void visitPyFile(PyFile node) {
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node));
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        PyExpression right;
        if (node.isAssignmentTo("__doc__") && (right = node.getAssignedValue()) instanceof PyStringLiteralExpression) {
            Annotation ann = this.getHolder().createInfoAnnotation((PsiElement)right, null);
            ann.setTextAttributes(PyHighlighter.PY_DOC_COMMENT);
            this.annotateDocStringStmt((PyStringLiteralExpression)right);
        }
    }

    @Override
    public void visitPyExpressionStatement(PyExpressionStatement node) {
        if (node.getExpression() instanceof PyStringLiteralExpression && DocStringUtil.isVariableDocString((PyStringLiteralExpression)node.getExpression())) {
            this.annotateDocStringStmt((PyStringLiteralExpression)node.getExpression());
        }
    }

    private void annotateDocStringStmt(PyStringLiteralExpression stmt) {
        if (stmt != null) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)stmt);
            if (module == null) {
                return;
            }
            PyDocumentationSettings settings = PyDocumentationSettings.getInstance(module);
            if (!settings.isPlain(stmt.getContainingFile())) {
                TextRange textRange;
                String[] tags = settings.isEpydocFormat(stmt.getContainingFile()) ? EpydocString.ALL_TAGS : SphinxDocString.ALL_TAGS;
                int pos = 0;
                while ((textRange = DocStringReferenceProvider.findNextTag(stmt.getText(), pos, tags)) != null) {
                    Annotation annotation = this.getHolder().createInfoAnnotation(textRange.shiftRight(stmt.getTextRange().getStartOffset()), null);
                    annotation.setTextAttributes(PyHighlighter.PY_DOC_COMMENT_TAG);
                    pos = textRange.getEndOffset();
                }
            }
        }
    }
}

