/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.quickfix.CompatibilityPrintCallQuickFix;
import com.jetbrains.python.inspections.quickfix.ConvertDictCompQuickFix;
import com.jetbrains.python.inspections.quickfix.ConvertSetLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.RemovePrefixQuickFix;
import com.jetbrains.python.inspections.quickfix.RemoveTrailingLQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBackquoteExpressionQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceBuiltinsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceExceptPartQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceListComprehensionsQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceNotEqOperatorQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceOctalNumericLiteralQuickFix;
import com.jetbrains.python.inspections.quickfix.ReplaceRaiseStatementQuickFix;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyConditionalExpression;
import com.jetbrains.python.psi.PyDictCompExpression;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFinallyPart;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyNoneLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPrintStatement;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyReprExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySetCompExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PySliceItem;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.impl.PyStringLiteralExpressionImpl;
import com.jetbrains.python.validation.PyAnnotator;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public abstract class CompatibilityVisitor
extends PyAnnotator {
    protected List<LanguageLevel> myVersionsToProcess;
    private String myCommonMessage = "Python version ";
    private static final Map<LanguageLevel, Set<String>> AVAILABLE_PREFIXES = Maps.newHashMap();

    public CompatibilityVisitor(List<LanguageLevel> versionsToProcess) {
        this.myVersionsToProcess = versionsToProcess;
    }

    @Override
    public void visitPyDictCompExpression(PyDictCompExpression node) {
        super.visitPyDictCompExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (languageLevel.supportsSetLiterals()) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support dictionary comprehensions", len, (PyElement)node, new ConvertDictCompQuickFix(), false);
    }

    @Override
    public void visitPySetLiteralExpression(PySetLiteralExpression node) {
        super.visitPySetLiteralExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (languageLevel.supportsSetLiterals()) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support set literal expressions", len, (PyElement)node, new ConvertSetLiteralQuickFix(), false);
    }

    @Override
    public void visitPySetCompExpression(PySetCompExpression node) {
        super.visitPySetCompExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (languageLevel.supportsSetLiterals()) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support set comprehensions", len, (PyElement)node, null, false);
    }

    @Override
    public void visitPyExceptBlock(PyExceptPart node) {
        super.visitPyExceptBlock(node);
        PyExpression exceptClass = node.getExceptClass();
        if (exceptClass != null) {
            if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24) || this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON25)) {
                PsiElement element = exceptClass.getNextSibling();
                while (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element != null && "as".equals(element.getText())) {
                    this.registerProblem(node, this.myCommonMessage + "2.4, 2.5 do not support this syntax.");
                }
            }
            int len = 0;
            StringBuilder message = new StringBuilder(this.myCommonMessage);
            for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
                LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
                if (!languageLevel.isPy3K()) continue;
                PsiElement element = exceptClass.getNextSibling();
                while (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element == null || !",".equals(element.getText())) continue;
                len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
            }
            this.commonRegisterProblem(message, " not support this syntax.", len, node, new ReplaceExceptPartQuickFix());
        }
    }

    @Override
    public void visitPyImportStatement(PyImportStatement node) {
        super.visitPyImportStatement(node);
        PyIfStatement ifParent = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)node, PyIfStatement.class);
        if (ifParent != null) {
            return;
        }
        PyImportElement[] importElements = node.getImportElements();
        int len = 0;
        String moduleName = "";
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            for (PyImportElement importElement : importElements) {
                QualifiedName qName = importElement.getImportedQName();
                if (qName == null) continue;
                if (!languageLevel.isPy3K()) {
                    if (!qName.matches(new String[]{"builtins"})) continue;
                    len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
                    moduleName = "builtins";
                    continue;
                }
                if (!qName.matches(new String[]{"__builtin__"})) continue;
                len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
                moduleName = "__builtin__";
            }
        }
        this.commonRegisterProblem(message, " not have module " + moduleName, len, node, new ReplaceBuiltinsQuickFix());
    }

    @Override
    public void visitPyStarExpression(PyStarExpression node) {
        super.visitPyStarExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (languageLevel.isPy3K()) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support this syntax. Starred expressions are not allowed as assignment targets in Python 2", len, node, null);
    }

    @Override
    public void visitPyBinaryExpression(PyBinaryExpression node) {
        super.visitPyBinaryExpression(node);
        int len = 0;
        if (node.isOperator("<>")) {
            StringBuilder message = new StringBuilder(this.myCommonMessage);
            for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
                LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
                if (!languageLevel.isPy3K()) continue;
                len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
            }
            this.commonRegisterProblem(message, " not support <>, use != instead.", len, node, new ReplaceNotEqOperatorQuickFix());
        }
    }

    @Override
    public void visitPyNumericLiteralExpression(PyNumericLiteralExpression node) {
        super.visitPyNumericLiteralExpression(node);
        int len = 0;
        Object quickFix = null;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        String suffix = "";
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            char c;
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (!languageLevel.isPy3K() || !node.isIntegerLiteral()) continue;
            String text = node.getText();
            if (text.endsWith("l") || text.endsWith("L")) {
                len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
                suffix = " not support a trailing 'l' or 'L'.";
                quickFix = new RemoveTrailingLQuickFix();
            }
            if (text.length() <= 1 || text.charAt(0) != '0' || (c = Character.toLowerCase(text.charAt(1))) == 'o' || c == 'b' || c == 'x') continue;
            boolean isNull = true;
            for (char a : text.toCharArray()) {
                if (a == '0') continue;
                isNull = false;
                break;
            }
            if (isNull) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
            quickFix = new ReplaceOctalNumericLiteralQuickFix();
            suffix = " not support this syntax. It requires '0o' prefix for octal literals";
        }
        this.commonRegisterProblem(message, suffix, len, node, (LocalQuickFix)quickFix);
    }

    @Override
    public void visitPyStringLiteralExpression(PyStringLiteralExpression node) {
        super.visitPyStringLiteralExpression(node);
        List<ASTNode> stringNodes = node.getStringNodes();
        for (ASTNode stringNode : stringNodes) {
            int len = 0;
            StringBuilder message = new StringBuilder(this.myCommonMessage);
            String nodeText = stringNode.getText();
            int index = PyStringLiteralExpressionImpl.getPrefixLength(nodeText);
            String prefix = nodeText.substring(0, index).toUpperCase();
            TextRange range = TextRange.create((int)stringNode.getStartOffset(), (int)(stringNode.getStartOffset() + index));
            for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
                Set<String> prefixes;
                LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
                if (prefix.isEmpty() || (prefixes = AVAILABLE_PREFIXES.get((Object)languageLevel)).contains(prefix)) continue;
                len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
            }
            this.commonRegisterProblem(message, " not support a '" + prefix + "' prefix", len, (PyElement)node, range, new RemovePrefixQuickFix(prefix));
        }
    }

    @Override
    public void visitPyListCompExpression(PyListCompExpression node) {
        super.visitPyListCompExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            boolean tmp = UnsupportedFeaturesUtil.visitPyListCompExpression(node, languageLevel);
            if (!tmp) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        for (ComprhForComponent forComponent : node.getForComponents()) {
            PyExpression iteratedList = forComponent.getIteratedList();
            this.commonRegisterProblem(message, " not support this syntax in list comprehensions.", len, iteratedList, new ReplaceListComprehensionsQuickFix());
        }
    }

    @Override
    public void visitPyRaiseStatement(PyRaiseStatement node) {
        LanguageLevel languageLevel;
        int i;
        super.visitPyRaiseStatement(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (i = 0; i != this.myVersionsToProcess.size(); ++i) {
            languageLevel = this.myVersionsToProcess.get(i);
            boolean hasNoArgs = UnsupportedFeaturesUtil.raiseHasNoArgs(node, languageLevel);
            if (!hasNoArgs) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support this syntax. Raise with no arguments can only be used in an except block", len, (PyElement)node, null, false);
        len = 0;
        message = new StringBuilder(this.myCommonMessage);
        for (i = 0; i != this.myVersionsToProcess.size(); ++i) {
            languageLevel = this.myVersionsToProcess.get(i);
            boolean hasTwoArgs = UnsupportedFeaturesUtil.raiseHasMoreThenOneArg(node, languageLevel);
            if (!hasTwoArgs) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support this syntax.", len, node, new ReplaceRaiseStatementQuickFix());
        len = 0;
        message = new StringBuilder(this.myCommonMessage);
        for (i = 0; i != this.myVersionsToProcess.size(); ++i) {
            languageLevel = this.myVersionsToProcess.get(i);
            boolean hasFrom = UnsupportedFeaturesUtil.raiseHasFromKeyword(node, languageLevel);
            if (!hasFrom) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support this syntax.", len, node, new ReplaceRaiseStatementQuickFix());
    }

    @Override
    public void visitPyReprExpression(PyReprExpression node) {
        super.visitPyReprExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (!languageLevel.isPy3K()) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support backquotes, use repr() instead", len, node, new ReplaceBackquoteExpressionQuickFix());
    }

    @Override
    public void visitPyWithStatement(PyWithStatement node) {
        super.visitPyWithStatement(node);
        HashSet<PyWithItem> problemItems = new HashSet<PyWithItem>();
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            PyWithItem[] items;
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (languageLevel == LanguageLevel.PYTHON24) {
                this.registerProblem(node, "Python version 2.4 doesn't support this syntax.");
                continue;
            }
            if (languageLevel.supportsSetLiterals() || (items = node.getWithItems()).length <= 1) continue;
            for (int j = 1; j < items.length; ++j) {
                if (!problemItems.isEmpty()) {
                    message.append(", ");
                }
                message.append(languageLevel.toString());
                problemItems.add(items[j]);
            }
        }
        message.append(" do not support multiple context managers");
        for (PyWithItem item : problemItems) {
            this.registerProblem((PsiElement)item, message.toString());
        }
    }

    @Override
    public void visitPyClass(PyClass node) {
        PyArgumentList list;
        super.visitPyClass(node);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24) && (list = node.getSuperClassExpressionList()) != null && list.getArguments().length == 0) {
            this.registerProblem((PsiElement)list, "Python version 2.4 does not support this syntax.");
        }
    }

    @Override
    public void visitPyPrintStatement(PyPrintStatement node) {
        super.visitPyPrintStatement(node);
        if (this.shouldBeCompatibleWithPy3()) {
            PsiElement[] arguments;
            boolean hasProblem = false;
            for (PsiElement element : arguments = node.getChildren()) {
                if (element instanceof PyParenthesizedExpression || element instanceof PyTupleExpression) continue;
                hasProblem = true;
                break;
            }
            if (hasProblem || arguments.length == 0) {
                this.registerProblem((PsiElement)node, "Python version >= 3.0 do not support this syntax. The print statement has been replaced with a print() function", new CompatibilityPrintCallQuickFix());
            }
        }
    }

    @Override
    public void visitPyFromImportStatement(PyFromImportStatement node) {
        super.visitPyFromImportStatement(node);
        PyReferenceExpression importSource = node.getImportSource();
        if (importSource != null) {
            PsiElement prev;
            if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24) && (prev = importSource.getPrevSibling()) != null && prev.getNode().getElementType() == PyTokenTypes.DOT) {
                this.registerProblem((PsiElement)node, "Python version 2.4 doesn't support this syntax.");
            }
        } else if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24)) {
            this.registerProblem((PsiElement)node, "Python version 2.4 doesn't support this syntax.");
        }
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        super.visitPyAssignmentStatement(node);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24)) {
            PyExpression assignedValue = node.getAssignedValue();
            Stack<PyExpression> st = new Stack<PyExpression>();
            if (assignedValue != null) {
                st.push(assignedValue);
            }
            while (!st.isEmpty()) {
                PsiElement el = (PsiElement)st.pop();
                if (el instanceof PyYieldExpression) {
                    this.registerProblem(node, "Python version 2.4 doesn't support this syntax. In Python <= 2.4, yield was a statement; it didn't return any value.");
                    continue;
                }
                for (PsiElement e : el.getChildren()) {
                    st.push((PyExpression)e);
                }
            }
        }
    }

    @Override
    public void visitPyConditionalExpression(PyConditionalExpression node) {
        super.visitPyConditionalExpression(node);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24)) {
            this.registerProblem((PsiElement)node, "Python version 2.4 doesn't support this syntax.");
        }
    }

    @Override
    public void visitPyTryExceptStatement(PyTryExceptStatement node) {
        super.visitPyTryExceptStatement(node);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24)) {
            PyExceptPart[] excepts = node.getExceptParts();
            PyFinallyPart finallyPart = node.getFinallyPart();
            if (excepts.length != 0 && finallyPart != null) {
                this.registerProblem((PsiElement)node, "Python version 2.4 doesn't support this syntax. You could use a finally block to ensure that code is always executed, or one or more except blocks to catch specific exceptions.");
            }
        }
    }

    @Override
    public void visitPyCallExpression(PyCallExpression node) {
        super.visitPyCallExpression(node);
        int len = 0;
        StringBuilder message = new StringBuilder(this.myCommonMessage);
        if (this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON24) || this.myVersionsToProcess.contains((Object)LanguageLevel.PYTHON25)) {
            boolean hasStar = false;
            for (PyExpression argument : node.getArguments()) {
                if (hasStar && argument instanceof PyKeywordArgument) {
                    this.registerProblem((PsiElement)argument, "Python version < 2.6 doesn't support this syntax. Named parameter cannot appear past *arg or **kwarg.");
                }
                if (!(argument instanceof PyStarArgument)) continue;
                hasStar = true;
            }
        }
        for (int i = 0; i != this.myVersionsToProcess.size(); ++i) {
            PyArgumentList argumentList;
            String name;
            PsiElement firstChild;
            LanguageLevel languageLevel = this.myVersionsToProcess.get(i);
            if (languageLevel.isPy3K() || (firstChild = node.getFirstChild()) == null || !"super".equals(name = firstChild.getText()) || (argumentList = node.getArgumentList()) == null || argumentList.getArguments().length != 0) continue;
            len = CompatibilityVisitor.appendLanguageLevel(message, len, languageLevel);
        }
        this.commonRegisterProblem(message, " not support this syntax. super() should have arguments in Python 2", len, node, null);
    }

    @Override
    public void visitPyYieldExpression(PyYieldExpression node) {
        super.visitPyYieldExpression(node);
        if (!node.isDelegating()) {
            return;
        }
        for (LanguageLevel level : this.myVersionsToProcess) {
            if (!level.isOlderThan(LanguageLevel.PYTHON33)) continue;
            this.registerProblem((PsiElement)node, "Python versions < 3.3 do not support this syntax. Delegating to a subgenerator is available since Python 3.3; use explicit iteration over subgenerator instead.");
            break;
        }
    }

    @Override
    public void visitPyReturnStatement(PyReturnStatement node) {
        boolean allowed = true;
        for (LanguageLevel level : this.myVersionsToProcess) {
            if (!level.isOlderThan(LanguageLevel.PYTHON33)) continue;
            allowed = false;
            break;
        }
        if (allowed) {
            return;
        }
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)node, PyFunction.class, (boolean)false, (Class[])new Class[]{PyClass.class});
        if (function != null && node.getExpression() != null) {
            YieldVisitor visitor = new YieldVisitor();
            function.acceptChildren(visitor);
            if (visitor.haveYield()) {
                this.registerProblem((PsiElement)node, "Python versions < 3.3 do not allow 'return' with argument inside generator.");
            }
        }
    }

    @Override
    public void visitPyNoneLiteralExpression(PyNoneLiteralExpression node) {
        if (this.shouldBeCompatibleWithPy2() && node.isEllipsis()) {
            PySubscriptionExpression subscription = (PySubscriptionExpression)PsiTreeUtil.getParentOfType((PsiElement)node, PySubscriptionExpression.class);
            if (subscription != null && PsiTreeUtil.isAncestor((PsiElement)subscription.getIndexExpression(), (PsiElement)node, (boolean)false)) {
                return;
            }
            PySliceItem sliceItem = (PySliceItem)PsiTreeUtil.getParentOfType((PsiElement)node, PySliceItem.class);
            if (sliceItem != null) {
                return;
            }
            this.registerProblem((PsiElement)node, "Python versions < 3.0 do not support '...' outside of sequence slicings.");
        }
    }

    protected abstract void registerProblem(PsiElement var1, String var2, @Nullable LocalQuickFix var3, boolean var4);

    protected abstract void registerProblem(PsiElement var1, TextRange var2, String var3, @Nullable LocalQuickFix var4, boolean var5);

    protected void registerProblem(PsiElement node, String s, @Nullable LocalQuickFix localQuickFix) {
        this.registerProblem(node, s, localQuickFix, true);
    }

    protected void registerProblem(PsiElement node, String s) {
        this.registerProblem(node, s, null);
    }

    protected void setVersionsToProcess(List<LanguageLevel> versionsToProcess) {
        this.myVersionsToProcess = versionsToProcess;
    }

    protected void commonRegisterProblem(StringBuilder initMessage, String suffix, int len, PyElement node, LocalQuickFix localQuickFix) {
        this.commonRegisterProblem(initMessage, suffix, len, node, node.getTextRange(), localQuickFix, true);
    }

    protected void commonRegisterProblem(StringBuilder initMessage, String suffix, int len, PyElement node, TextRange range, LocalQuickFix localQuickFix) {
        this.commonRegisterProblem(initMessage, suffix, len, node, range, localQuickFix, true);
    }

    protected void commonRegisterProblem(StringBuilder initMessage, String suffix, int len, PyElement node, TextRange range, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        initMessage.append(" do");
        if (len == 1) {
            initMessage.append("es");
        }
        initMessage.append(suffix);
        if (len != 0) {
            this.registerProblem((PsiElement)node, range, initMessage.toString(), localQuickFix, asError);
        }
    }

    protected void commonRegisterProblem(StringBuilder initMessage, String suffix, int len, PyElement node, @Nullable LocalQuickFix localQuickFix, boolean asError) {
        initMessage.append(" do");
        if (len == 1) {
            initMessage.append("es");
        }
        initMessage.append(suffix);
        if (len != 0) {
            this.registerProblem((PsiElement)node, node.getTextRange(), initMessage.toString(), localQuickFix, asError);
        }
    }

    protected static int appendLanguageLevel(StringBuilder message, int len, LanguageLevel languageLevel) {
        if (len != 0) {
            message.append(", ");
        }
        message.append(languageLevel.toString());
        return ++len;
    }

    @Override
    public void visitPyNonlocalStatement(PyNonlocalStatement node) {
        if (this.shouldBeCompatibleWithPy2()) {
            this.registerProblem((PsiElement)node, "nonlocal keyword available only since py3", null, false);
        }
    }

    protected boolean shouldBeCompatibleWithPy2() {
        for (LanguageLevel level : this.myVersionsToProcess) {
            if (!level.isOlderThan(LanguageLevel.PYTHON30)) continue;
            return true;
        }
        return false;
    }

    protected boolean shouldBeCompatibleWithPy3() {
        for (LanguageLevel level : this.myVersionsToProcess) {
            if (!level.isPy3K()) continue;
            return true;
        }
        return false;
    }

    static {
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON24, Sets.newHashSet((Object[])new String[]{"R", "U", "UR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON25, Sets.newHashSet((Object[])new String[]{"R", "U", "UR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON26, Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON27, Sets.newHashSet((Object[])new String[]{"R", "U", "UR", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON30, Sets.newHashSet((Object[])new String[]{"R", "B"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON31, Sets.newHashSet((Object[])new String[]{"R", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON32, Sets.newHashSet((Object[])new String[]{"R", "B", "BR"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON33, Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB"}));
        AVAILABLE_PREFIXES.put(LanguageLevel.PYTHON34, Sets.newHashSet((Object[])new String[]{"R", "U", "B", "BR", "RB"}));
    }

    private static class YieldVisitor
    extends PyElementVisitor {
        private boolean _haveYield = false;

        private YieldVisitor() {
        }

        public boolean haveYield() {
            return this._haveYield;
        }

        @Override
        public void visitPyYieldExpression(PyYieldExpression node) {
            this._haveYield = true;
        }

        @Override
        public void visitPyElement(PyElement node) {
            if (!this._haveYield) {
                node.acceptChildren(this);
            }
        }

        @Override
        public void visitPyFunction(PyFunction node) {
        }
    }
}

