/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.toolbox;

import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Substring
implements CharSequence {
    private static final Pattern RE_NL = Pattern.compile("(\\r?\\n)");
    @NotNull
    private final String myString;
    private final int myStartOffset;
    private final int myEndOffset;

    public Substring(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/toolbox/Substring", "<init>"));
        }
        this(s, 0, s.length());
    }

    public Substring(@NotNull String s, int start, int end) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/toolbox/Substring", "<init>"));
        }
        this.myString = s;
        this.myStartOffset = start;
        this.myEndOffset = end;
    }

    public boolean equals(Object o) {
        if (o instanceof String) {
            return this.toString().equals(o);
        }
        if (o instanceof Substring) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getValue();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "toString"));
        }
        return string;
    }

    @NotNull
    public String getValue() {
        String string = this.getTextRange().substring(this.myString);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "getValue"));
        }
        return string;
    }

    @NotNull
    public String getSuperString() {
        String string = this.myString;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "getSuperString"));
        }
        return string;
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange textRange = TextRange.create((int)this.myStartOffset, (int)this.myEndOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "getTextRange"));
        }
        return textRange;
    }

    @NotNull
    public List<Substring> split(@NotNull String regex) {
        if (regex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regex", "com/jetbrains/python/toolbox/Substring", "split"));
        }
        List<Substring> list = this.split(Pattern.compile(regex));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "split"));
        }
        return list;
    }

    @NotNull
    public List<Substring> split(@NotNull Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pattern", "com/jetbrains/python/toolbox/Substring", "split"));
        }
        ArrayList<Substring> result = new ArrayList<Substring>();
        Matcher m = pattern.matcher(this.myString);
        int start = this.myStartOffset;
        int end = this.myEndOffset;
        if (m.find(start)) {
            do {
                end = m.start();
                result.add(this.createAnotherSubstring(start, Math.min(end, this.myEndOffset)));
                start = m.end();
            } while (end < this.myEndOffset && m.find());
            if (start < this.myEndOffset) {
                result.add(this.createAnotherSubstring(start, this.myEndOffset));
            }
        } else {
            result.add(this.createAnotherSubstring(start, end));
        }
        ArrayList<Substring> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "split"));
        }
        return arrayList;
    }

    @NotNull
    public List<Substring> splitLines() {
        List<Substring> list = this.split(RE_NL);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "splitLines"));
        }
        return list;
    }

    @NotNull
    public Substring trim() {
        int end;
        int start;
        for (start = this.myStartOffset; start < this.myEndOffset && this.myString.charAt(start) <= ' '; ++start) {
        }
        for (end = this.myEndOffset - 1; end > start && this.myString.charAt(end) <= ' '; --end) {
        }
        Substring substring = this.createAnotherSubstring(start, end + 1);
        if (substring == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "trim"));
        }
        return substring;
    }

    @NotNull
    public Substring getMatcherGroup(@NotNull Matcher m, int group) {
        if (m == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "m", "com/jetbrains/python/toolbox/Substring", "getMatcherGroup"));
        }
        Substring substring = this.substring(m.start(group), m.end(group));
        if (substring == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "getMatcherGroup"));
        }
        return substring;
    }

    @Override
    public int length() {
        return this.myEndOffset - this.myStartOffset;
    }

    @Override
    public char charAt(int i) {
        return this.myString.charAt(this.myStartOffset + i);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public boolean startsWith(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/toolbox/Substring", "startsWith"));
        }
        return this.indexOf(prefix) == 0;
    }

    public boolean endsWith(@NotNull String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/toolbox/Substring", "endsWith"));
        }
        return this.myString.lastIndexOf(prefix) == this.length();
    }

    public int indexOf(@NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/python/toolbox/Substring", "indexOf"));
        }
        int n = this.myString.indexOf(s, this.myStartOffset);
        return n < this.myEndOffset ? n - this.myStartOffset : -1;
    }

    @NotNull
    public Substring substring(int start) {
        Substring substring = this.substring(start, this.length());
        if (substring == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "substring"));
        }
        return substring;
    }

    @NotNull
    public Substring substring(int start, int end) {
        Substring substring = this.createAnotherSubstring(this.myStartOffset + start, this.myStartOffset + end);
        if (substring == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "substring"));
        }
        return substring;
    }

    @NotNull
    public String concatTrimmedLines(@NotNull String separator) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/jetbrains/python/toolbox/Substring", "concatTrimmedLines"));
        }
        StringBuilder b = new StringBuilder();
        List<Substring> lines = this.splitLines();
        int n = lines.size();
        for (int i = 0; i < n; ++i) {
            b.append(lines.get(i).trim().toString());
            if (i >= n - 1) continue;
            b.append(separator);
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "concatTrimmedLines"));
        }
        return string;
    }

    @NotNull
    private Substring createAnotherSubstring(int start, int end) {
        Substring substring = new Substring(this.myString, start, end);
        if (substring == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/Substring", "createAnotherSubstring"));
        }
        return substring;
    }
}

