/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.toolbox;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class RepeatIterator<T>
implements Iterator<T> {
    private final List<T> master;
    private Iterator<T> source;

    public RepeatIterator(@NotNull List<T> master) {
        if (master == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "master", "com/jetbrains/python/toolbox/RepeatIterator", "<init>"));
        }
        this.master = master;
        this.source = master.iterator();
    }

    public RepeatIterator(@NotNull T single) {
        if (single == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "single", "com/jetbrains/python/toolbox/RepeatIterator", "<init>"));
        }
        this.master = new ArrayList<T>(1);
        this.master.add(single);
        this.source = this.master.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.master.size() > 0;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This is a read-only endless iterator");
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.source.hasNext()) {
            this.source = this.master.iterator();
        }
        return this.source.next();
    }
}

