/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.toolbox;

import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class FP {
    private FP() {
    }

    @NotNull
    public static <S, R> Iterable<R> map(final @NotNull Lambda1<S, R> lambda, final @NotNull Iterable<S> source) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/jetbrains/python/toolbox/FP", "map"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/toolbox/FP", "map"));
        }
        Iterable iterable = new Iterable<R>(){
            final Iterator<S> feeder;
            {
                this.feeder = source.iterator();
            }

            @Override
            public Iterator<R> iterator() {
                return new Iterator<R>(){

                    @Override
                    public boolean hasNext() {
                        return feeder.hasNext();
                    }

                    @Override
                    public R next() {
                        return lambda.apply(feeder.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove from map()");
                    }
                };
            }
        };
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/FP", "map"));
        }
        return iterable;
    }

    @NotNull
    public static <S, R> Iterable<R> map(@NotNull Lambda1<S, R> lambda, @NotNull S[] source) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/jetbrains/python/toolbox/FP", "map"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/toolbox/FP", "map"));
        }
        Iterable<R> iterable = FP.map(lambda, Arrays.asList(source));
        if (iterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/toolbox/FP", "map"));
        }
        return iterable;
    }

    public static <S, R> List<R> mapList(@NotNull Lambda1<S, R> lambda, @NotNull Iterable<S> source) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/jetbrains/python/toolbox/FP", "mapList"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/toolbox/FP", "mapList"));
        }
        ArrayList<R> ret = new ArrayList<R>(source instanceof Collection ? ((Collection)source).size() : 10);
        for (R what : FP.map(lambda, source)) {
            ret.add(what);
        }
        return ret;
    }

    public static <AccT, ItemT> AccT fold(@NotNull Lambda2<AccT, ItemT, AccT> lambda, @NotNull Iterable<ItemT> source, @NotNull AccT unit) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/jetbrains/python/toolbox/FP", "fold"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/toolbox/FP", "fold"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/jetbrains/python/toolbox/FP", "fold"));
        }
        AccT ret = unit;
        for (ItemT item : source) {
            ret = lambda.apply(ret, item);
        }
        return ret;
    }

    public static <AccT, ItemT> AccT foldr(@NotNull Lambda2<ItemT, AccT, AccT> lambda, @NotNull Iterable<ItemT> source, @NotNull AccT unit) {
        if (lambda == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambda", "com/jetbrains/python/toolbox/FP", "foldr"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/jetbrains/python/toolbox/FP", "foldr"));
        }
        if (unit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unit", "com/jetbrains/python/toolbox/FP", "foldr"));
        }
        AccT ret = unit;
        for (ItemT item : source) {
            ret = lambda.apply(item, ret);
        }
        return ret;
    }

    public static <R1, R2> Iterable<Pair<R1, R2>> zip(Iterable<R1> one, Iterable<R2> two) {
        return FP.zipInternal(one, two, null, null, false, false);
    }

    public static <R1, R2> List<Pair<R1, R2>> zipList(Iterable<R1> one, Iterable<R2> two) {
        ArrayList<Pair<R1, R2>> ret = new ArrayList<Pair<R1, R2>>(FP.proposeZippedListLength(one, two, false, false));
        for (Pair<Object, Object> what : FP.zipInternal(one, two, null, null, false, false)) {
            ret.add(what);
        }
        return ret;
    }

    public static <R1, R2> Iterable<Pair<R1, R2>> zip(Iterable<R1> one, Iterable<R2> two, R2 filler) {
        return FP.zipInternal(one, two, null, filler, false, true);
    }

    public static <R1, R2> List<Pair<R1, R2>> zipList(Iterable<R1> one, Iterable<R2> two, R2 filler) {
        ArrayList<Pair<R1, R2>> ret = new ArrayList<Pair<R1, R2>>(FP.proposeZippedListLength(one, two, false, true));
        for (Pair<Object, R2> what : FP.zipInternal(one, two, null, filler, false, true)) {
            ret.add(what);
        }
        return ret;
    }

    public static <R1, R2> Iterable<Pair<R1, R2>> zip(Iterable<R1> one, Iterable<R2> two, R1 filler1, R2 filler2) {
        return FP.zipInternal(one, two, filler1, filler2, true, true);
    }

    public static <R1, R2> List<Pair<R1, R2>> zipList(Iterable<R1> one, Iterable<R2> two, R1 filler1, R2 filler2) {
        ArrayList<Pair<R1, R2>> ret = new ArrayList<Pair<R1, R2>>(FP.proposeZippedListLength(one, two, true, true));
        for (Pair<R1, R2> what : FP.zipInternal(one, two, filler1, filler2, true, true)) {
            ret.add(what);
        }
        return ret;
    }

    public static int proposeZippedListLength(Iterable one, Iterable two, boolean fill1, boolean fill2) {
        int size1 = 0;
        int size2 = 0;
        int approx_size = 0;
        if (one instanceof List) {
            size1 = ((List)one).size();
        }
        if (two instanceof List) {
            size2 = ((List)two).size();
        }
        if (fill1 && fill2) {
            approx_size = Math.max(size1, size2);
        }
        if (!fill1 && !fill2) {
            approx_size = Math.min(size1, size2);
        }
        if (fill1 && !fill2) {
            approx_size = size1;
        }
        if (!fill1 && fill2) {
            approx_size = size2;
        }
        if (approx_size == 0) {
            approx_size = 10;
        }
        return approx_size;
    }

    private static <R1, R2> Iterable<Pair<R1, R2>> zipInternal(Iterable<R1> one, Iterable<R2> two, final R1 filler1, final R2 filler2, final boolean fill1, final boolean fill2) {
        final Iterator<R1> one_iter = one.iterator();
        final Iterator<R2> two_iter = two.iterator();
        return new Iterable<Pair<R1, R2>>(){

            @Override
            public Iterator<Pair<R1, R2>> iterator() {
                return new Iterator<Pair<R1, R2>>(){

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove from zip()");
                    }

                    @Override
                    public boolean hasNext() {
                        boolean one_has = one_iter.hasNext();
                        boolean two_has = two_iter.hasNext();
                        return one_has && two_has || fill1 && two_has || fill2 && one_has;
                    }

                    @Override
                    public Pair<R1, R2> next() {
                        if (one_iter.hasNext() && two_iter.hasNext()) {
                            return Pair.create(one_iter.next(), two_iter.next());
                        }
                        if (fill1 && two_iter.hasNext()) {
                            return Pair.create((Object)filler1, two_iter.next());
                        }
                        if (fill2 && one_iter.hasNext()) {
                            return Pair.create(one_iter.next(), (Object)filler2);
                        }
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    public static <A1, R1, R2> Lambda1<A1, R2> combine(final Lambda1<A1, R1> f, final Lambda1<R1, R2> g) {
        return new Lambda1<A1, R2>(){

            @Override
            public R2 apply(A1 arg) {
                return g.apply(f.apply(arg));
            }
        };
    }

    public static class StringCollector<T>
    implements Lambda2<StringBuilder, T, StringBuilder> {
        @Override
        public StringBuilder apply(StringBuilder builder, T arg2) {
            if (arg2 == null) {
                throw new IllegalArgumentException("Null item in list of strings to concatenate. Text so far: " + builder.toString());
            }
            return builder.append(arg2.toString());
        }
    }

    public static interface Lambda2<A1, A2, R> {
        public R apply(A1 var1, A2 var2);
    }

    public static interface Lambda1<A, R> {
        public R apply(A var1);
    }
}

