/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.toolbox;

import com.jetbrains.python.toolbox.ChainedListBase;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;

abstract class ChainIterationMixin<T, TPayload> {
    protected ChainedListBase<TPayload> myLink;
    protected Iterator<T> myCurrent;

    public ChainIterationMixin(ChainedListBase<TPayload> link) {
        this.myLink = link;
    }

    public abstract Iterator<T> toIterator(TPayload var1);

    @Nullable
    public Iterator<T> getCurrent() {
        while ((this.myCurrent == null || !this.myCurrent.hasNext()) && this.myLink.hasPayload()) {
            if (this.myCurrent == null) {
                this.myCurrent = this.toIterator(this.myLink.myPayload);
                assert (this.myCurrent != null);
                continue;
            }
            this.myLink.moveOn();
            this.myCurrent = null;
        }
        return this.myCurrent;
    }

    public boolean hasNext() {
        Iterator<T> current = this.getCurrent();
        return current != null;
    }

    public T next() {
        Iterator<T> current = this.getCurrent();
        if (current != null) {
            return current.next();
        }
        throw new NoSuchElementException();
    }
}

