/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.unittest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.unittest.PythonUnitTestCommandLineState;
import com.jetbrains.python.testing.unittest.PythonUnitTestRunConfigurationEditor;
import com.jetbrains.python.testing.unittest.PythonUnitTestRunConfigurationParams;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PythonUnitTestRunConfiguration
extends AbstractPythonTestRunConfiguration
implements PythonUnitTestRunConfigurationParams {
    private boolean myIsPureUnittest = true;
    protected String myTitle = "Unittest";
    protected String myPluralTitle = "Unittests";
    private String myParams = "";
    private boolean useParam = false;

    public PythonUnitTestRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        return new PythonUnitTestRunConfigurationEditor(this.getProject(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/testing/unittest/PythonUnitTestRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/testing/unittest/PythonUnitTestRunConfiguration", "getState"));
        }
        return new PythonUnitTestCommandLineState(this, env);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.myIsPureUnittest = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"PUREUNITTEST"));
        this.myParams = JDOMExternalizerUtil.readField((Element)element, (String)"PARAMS");
        this.useParam = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_PARAM"));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"PUREUNITTEST", (String)String.valueOf(this.myIsPureUnittest));
        JDOMExternalizerUtil.writeField((Element)element, (String)"PARAMS", (String)this.myParams);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_PARAM", (String)String.valueOf(this.useParam));
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    @Override
    protected String getTitle() {
        return this.myTitle;
    }

    @Override
    protected String getPluralTitle() {
        return this.myPluralTitle;
    }

    public static void copyParams(PythonUnitTestRunConfigurationParams source, PythonUnitTestRunConfigurationParams target) {
        PythonUnitTestRunConfiguration.copyParams(source.getTestRunConfigurationParams(), target.getTestRunConfigurationParams());
        target.setPureUnittest(source.isPureUnittest());
        target.setParams(source.getParams());
        target.useParam(source.useParam());
    }

    @Override
    public boolean isPureUnittest() {
        return this.myIsPureUnittest;
    }

    @Override
    public void setPureUnittest(boolean isPureUnittest) {
        this.myIsPureUnittest = isPureUnittest;
    }

    @Override
    public String getParams() {
        return this.myParams;
    }

    @Override
    public void setParams(String pattern) {
        this.myParams = pattern;
    }

    @Override
    public boolean useParam() {
        return this.useParam;
    }

    @Override
    public void useParam(boolean useParam) {
        this.useParam = useParam;
    }
}

