/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.unittest;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestConfigurationProducer;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.python.testing.unittest.PythonUnitTestRunConfiguration;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonUnitTestConfigurationProducer
extends PythonTestConfigurationProducer {
    public PythonUnitTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().PY_UNITTEST_FACTORY);
    }

    @Override
    protected boolean isAvailable(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/testing/unittest/PythonUnitTestConfigurationProducer", "isAvailable"));
        }
        PsiElement element = location.getPsiElement();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return false;
        }
        return TestRunnerService.getInstance(module).getProjectConfiguration().equals(PythonTestConfigurationsModel.PYTHONS_UNITTEST_NAME);
    }

    @Override
    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/testing/unittest/PythonUnitTestConfigurationProducer", "isTestFunction"));
        }
        boolean isTestFunction = super.isTestFunction(pyFunction, configuration);
        return isTestFunction || configuration instanceof PythonUnitTestRunConfiguration && !((PythonUnitTestRunConfiguration)configuration).isPureUnittest();
    }

    @Override
    protected boolean isTestClass(@NotNull PyClass pyClass, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/testing/unittest/PythonUnitTestConfigurationProducer", "isTestClass"));
        }
        boolean isTestClass = super.isTestClass(pyClass, configuration);
        return isTestClass || configuration instanceof PythonUnitTestRunConfiguration && !((PythonUnitTestRunConfiguration)configuration).isPureUnittest();
    }

    @Override
    protected boolean isTestFile(@NotNull PyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/testing/unittest/PythonUnitTestConfigurationProducer", "isTestFile"));
        }
        if ("setup.py".equals(file.getName())) {
            return true;
        }
        List<PyStatement> testCases = this.getTestCaseClassesFromFile(file);
        return !testCases.isEmpty();
    }
}

