/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.unittest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.unittest.PythonUnitTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;

public class PythonUnitTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PythonUnitTestRunConfiguration myConfig;
    private static final String UTRUNNER_PY = "pycharm/utrunner.py";
    private static final String SETUP_PY_TESTRUNNER = "pycharm/pycharm_setup_runner.py";

    public PythonUnitTestCommandLineState(PythonUnitTestRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected String getRunner() {
        if (this.myConfig.getTestType() == AbstractPythonTestRunConfiguration.TestType.TEST_SCRIPT && this.myConfig.getScriptName().endsWith("setup.py")) {
            return SETUP_PY_TESTRUNNER;
        }
        return UTRUNNER_PY;
    }

    @Override
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String scriptName = FileUtil.toSystemDependentName((String)this.myConfig.getScriptName());
        switch (this.myConfig.getTestType()) {
            case TEST_SCRIPT: {
                specs.add(scriptName);
                break;
            }
            case TEST_CLASS: {
                specs.add(scriptName + "::" + this.myConfig.getClassName());
                break;
            }
            case TEST_METHOD: {
                specs.add(scriptName + "::" + this.myConfig.getClassName() + "::" + this.myConfig.getMethodName());
                break;
            }
            case TEST_FOLDER: {
                String folderName = FileUtil.toSystemDependentName((String)(this.myConfig.getFolderName() + "/"));
                if (!StringUtil.isEmpty((String)this.myConfig.getPattern()) && this.myConfig.usePattern()) {
                    specs.add(folderName + ";" + this.myConfig.getPattern());
                    break;
                }
                specs.add(folderName);
                break;
            }
            case TEST_FUNCTION: {
                specs.add(scriptName + "::::" + this.myConfig.getMethodName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test type: " + (Object)((Object)this.myConfig.getTestType()));
            }
        }
        return specs;
    }

    @Override
    protected void addAfterParameters(GeneralCommandLine cmd) throws ExecutionException {
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        if (this.myConfig.useParam() && !StringUtil.isEmptyOrSpaces((String)this.myConfig.getParams())) {
            script_params.addParameter(this.myConfig.getParams());
        }
        if (this.myConfig.getTestType() != AbstractPythonTestRunConfiguration.TestType.TEST_SCRIPT || !this.myConfig.getScriptName().endsWith("setup.py")) {
            script_params.addParameter(String.valueOf(this.myConfig.isPureUnittest()));
        }
    }
}

