/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class PyTestUtil {
    private static final Set<String> PYTHON_TEST_QUALIFIED_CLASSES = ImmutableSet.of((Object)"unittest.TestCase", (Object)"unittest.case.TestCase");

    public static List<PyStatement> getPyTestCasesFromFile(PsiFileSystemItem file) {
        List<Object> result = Lists.newArrayList();
        if (file instanceof PyFile) {
            result = PyTestUtil.getResult((PyFile)file);
        } else if (file instanceof PsiDirectory) {
            for (PsiFile f : ((PsiDirectory)file).getFiles()) {
                if (!(f instanceof PyFile)) continue;
                result.addAll(PyTestUtil.getResult((PyFile)f));
            }
        }
        return result;
    }

    private static List<PyStatement> getResult(PyFile file) {
        ArrayList result = Lists.newArrayList();
        for (PyClass pyClass : file.getTopLevelClasses()) {
            if (!PyTestUtil.isPyTestClass(pyClass)) continue;
            result.add(pyClass);
        }
        for (PyFunction pyFunction : file.getTopLevelFunctions()) {
            if (!PyTestUtil.isPyTestFunction(pyFunction)) continue;
            result.add(pyFunction);
        }
        return result;
    }

    public static boolean isPyTestFunction(PyFunction pyFunction) {
        String name = pyFunction.getName();
        return name != null && name.startsWith("test");
    }

    public static boolean isPyTestClass(PyClass pyClass) {
        for (PyClassLikeType type : pyClass.getAncestorTypes(TypeEvalContext.codeInsightFallback(pyClass.getProject()))) {
            if (type == null || !PYTHON_TEST_QUALIFIED_CLASSES.contains(type.getClassQName())) continue;
            return true;
        }
        String className = pyClass.getName();
        if (className == null) {
            return false;
        }
        String name = className.toLowerCase();
        if (name.startsWith("test")) {
            for (PyFunction cls : pyClass.getMethods(false)) {
                if (!PyTestUtil.isPyTestFunction(cls)) continue;
                return true;
            }
        }
        return false;
    }
}

