/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class PyTestTracebackFilter
implements Filter {
    private final Project myProject;
    private final String myWorkingDirectory;
    private final Pattern myMatchingPattern = Pattern.compile("([^\"]+):(\\d+)");

    public PyTestTracebackFilter(Project project, @Nullable String workingDirectory) {
        this.myProject = project;
        this.myWorkingDirectory = workingDirectory;
    }

    public Filter.Result applyFilter(String line, int entireLength) {
        Matcher matcher = this.myMatchingPattern.matcher(line);
        if (matcher.find()) {
            String fileName = matcher.group(1).replace('\\', '/');
            int lineNumber = Integer.parseInt(matcher.group(2));
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fileName);
            if (vFile == null && !StringUtil.isEmptyOrSpaces((String)this.myWorkingDirectory)) {
                vFile = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myWorkingDirectory, fileName));
            }
            if (vFile != null) {
                OpenFileHyperlinkInfo hyperlink = new OpenFileHyperlinkInfo(this.myProject, vFile, lineNumber - 1);
                int textStartOffset = entireLength - line.length();
                int startPos = 0;
                int endPos = line.lastIndexOf(58);
                return new Filter.Result(startPos + textStartOffset, endPos + textStartOffset, (HyperlinkInfo)hyperlink);
            }
        }
        return null;
    }
}

