/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import com.jetbrains.python.testing.pytest.PyTestCommandLineState;
import com.jetbrains.python.testing.pytest.PyTestConfigurationEditor;
import com.jetbrains.python.testing.pytest.PyTestRunConfigurationParams;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PyTestRunConfiguration
extends AbstractPythonTestRunConfiguration
implements PyTestRunConfigurationParams {
    private String myTestToRun = "";
    private String myKeywords = "";
    private String myParams = "";
    private boolean useParam = false;
    private boolean useKeyword = false;
    protected String myTitle = "py.test";
    protected String myPluralTitle = "py.tests";
    private static final String TEST_TO_RUN_FIELD = "testToRun";
    private static final String KEYWORDS_FIELD = "keywords";
    private static final String PARAMS_FIELD = "params";

    public PyTestRunConfiguration(Project project, ConfigurationFactory factory) {
        super(project, factory);
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        return new PyTestConfigurationEditor(this.getProject(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/testing/pytest/PyTestRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/testing/pytest/PyTestRunConfiguration", "getState"));
        }
        return new PyTestCommandLineState(this, env);
    }

    public String getTestToRun() {
        return this.myTestToRun;
    }

    public void setTestToRun(String testToRun) {
        this.myTestToRun = testToRun;
    }

    public String getKeywords() {
        if (this.useKeyword) {
            return this.myKeywords;
        }
        return "";
    }

    public void setKeywords(String keywords) {
        this.myKeywords = keywords;
    }

    public void setParams(String params) {
        this.myParams = params;
    }

    public String getParams() {
        if (this.useParam) {
            return this.myParams;
        }
        return "";
    }

    @Override
    public boolean useParam() {
        return this.useParam;
    }

    @Override
    public void useParam(boolean useParam) {
        this.useParam = useParam;
    }

    @Override
    public boolean useKeyword() {
        return this.useKeyword;
    }

    @Override
    public void useKeyword(boolean useKeyword) {
        this.useKeyword = useKeyword;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.myTestToRun = JDOMExternalizerUtil.readField((Element)element, (String)TEST_TO_RUN_FIELD);
        this.myKeywords = JDOMExternalizerUtil.readField((Element)element, (String)KEYWORDS_FIELD);
        this.myParams = JDOMExternalizerUtil.readField((Element)element, (String)PARAMS_FIELD);
        this.useParam = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_PARAM"));
        this.useKeyword = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_KEYWORD"));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)TEST_TO_RUN_FIELD, (String)this.myTestToRun);
        JDOMExternalizerUtil.writeField((Element)element, (String)KEYWORDS_FIELD, (String)this.myKeywords);
        JDOMExternalizerUtil.writeField((Element)element, (String)PARAMS_FIELD, (String)this.myParams);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_PARAM", (String)String.valueOf(this.useParam));
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_KEYWORD", (String)String.valueOf(this.useKeyword));
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        if (StringUtil.isEmptyOrSpaces((String)this.myTestToRun)) {
            throw new RuntimeConfigurationError("Please specify target folder or script");
        }
        Sdk sdkPath = PythonSdkType.findSdkByPath(this.getInterpreterPath());
        if (sdkPath != null && !VFSTestFrameworkListener.getInstance().isPyTestInstalled(sdkPath)) {
            throw new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", "py.test"));
        }
    }

    @Override
    public String suggestedName() {
        return "py.test in " + this.getName();
    }

    @Override
    protected String getTitle() {
        return this.myTitle;
    }

    @Override
    protected String getPluralTitle() {
        return this.myPluralTitle;
    }
}

