/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestConfigurationProducer;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.python.testing.pytest.PyTestRunConfiguration;
import com.jetbrains.python.testing.pytest.PyTestUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTestConfigurationProducer
extends PythonTestConfigurationProducer {
    public PyTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().PY_PYTEST_FACTORY);
    }

    @Override
    protected boolean setupConfigurationFromContext(AbstractPythonTestRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        PsiDirectory file;
        PsiElement element = (PsiElement)sourceElement.get();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (!(configuration instanceof PyTestRunConfiguration)) {
            return false;
        }
        if (module == null) {
            return false;
        }
        if (!TestRunnerService.getInstance(module).getProjectConfiguration().equals(PythonTestConfigurationsModel.PY_TEST_NAME)) {
            return false;
        }
        Object object = file = element instanceof PsiDirectory ? (PsiDirectory)element : element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file instanceof PyFile || file instanceof PsiDirectory) {
            List<PyStatement> testCases = PyTestUtil.getPyTestCasesFromFile((PsiFileSystemItem)file);
            if (testCases.isEmpty()) {
                return false;
            }
        } else {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(context.getModule());
        if (sdk == null) {
            return false;
        }
        configuration.setUseModuleSdk(true);
        configuration.setModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
        ((PyTestRunConfiguration)configuration).setTestToRun(virtualFile.getPath());
        String keywords = PyTestConfigurationProducer.getKeywords(element, sdk);
        if (keywords != null) {
            ((PyTestRunConfiguration)configuration).useKeyword(true);
            ((PyTestRunConfiguration)configuration).setKeywords(keywords);
            configuration.setName("py.test in " + keywords);
        } else {
            configuration.setName("py.test in " + file.getName());
        }
        return true;
    }

    @Nullable
    private static String getKeywords(@NotNull PsiElement element, @NotNull Sdk sdk) {
        String keywords;
        block9: {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/testing/pytest/PyTestConfigurationProducer", "getKeywords"));
            }
            if (sdk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/testing/pytest/PyTestConfigurationProducer", "getKeywords"));
            }
            PyFunction pyFunction = PyTestConfigurationProducer.findTestFunction(element);
            PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
            keywords = null;
            if (pyFunction != null) {
                keywords = pyFunction.getName();
                if (pyClass != null) {
                    PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
                    try {
                        PyPackage pytestPackage = packageManager.findPackage("pytest", false);
                        if (pytestPackage != null && PackageVersionComparator.VERSION_COMPARATOR.compare(pytestPackage.getVersion(), "2.3.3") >= 0) {
                            keywords = pyClass.getName() + " and " + keywords;
                            break block9;
                        }
                        keywords = pyClass.getName() + "." + keywords;
                    }
                    catch (ExecutionException e) {
                        keywords = pyClass.getName() + "." + keywords;
                    }
                }
            } else if (pyClass != null) {
                keywords = pyClass.getName();
            }
        }
        return keywords;
    }

    @Nullable
    private static PyFunction findTestFunction(PsiElement element) {
        String name;
        PyFunction function = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class);
        if (function != null && (name = function.getName()) != null && name.startsWith("test")) {
            return function;
        }
        return null;
    }

    @Override
    public boolean isConfigurationFromContext(AbstractPythonTestRunConfiguration configuration, ConfigurationContext context) {
        PsiDirectory file;
        Location location = context.getLocation();
        if (location == null) {
            return false;
        }
        if (!(configuration instanceof PyTestRunConfiguration)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        Object object = file = element instanceof PsiDirectory ? (PsiDirectory)element : element.getContainingFile();
        if (file == null) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (file instanceof PyFile || file instanceof PsiDirectory) {
            List<PyStatement> testCases = PyTestUtil.getPyTestCasesFromFile((PsiFileSystemItem)file);
            if (testCases.isEmpty()) {
                return false;
            }
        } else {
            return false;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(context.getModule());
        if (sdk == null) {
            return false;
        }
        String keywords = PyTestConfigurationProducer.getKeywords(element, sdk);
        String scriptName = ((PyTestRunConfiguration)configuration).getTestToRun();
        String workingDirectory = configuration.getWorkingDirectory();
        String path = virtualFile.getPath();
        boolean isTestFileEquals = scriptName.equals(path) || path.equals(new File(workingDirectory, scriptName).getAbsolutePath());
        String configurationKeywords = ((PyTestRunConfiguration)configuration).getKeywords();
        return isTestFileEquals && (configurationKeywords.equals(keywords) || StringUtil.isEmptyOrSpaces((String)((PyTestRunConfiguration)configuration).getKeywords()) && keywords == null);
    }
}

