/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.AbstractPyCommonOptionsForm;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.PyCommonOptionsFormFactory;
import com.jetbrains.python.testing.pytest.PyTestRunConfiguration;
import com.jetbrains.python.testing.pytest.PyTestRunConfigurationParams;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class PyTestConfigurationEditor
extends SettingsEditor<PyTestRunConfiguration>
implements PanelWithAnchor,
PyTestRunConfigurationParams {
    private JPanel myMainPanel;
    private JPanel myCommonOptionsPlaceholder;
    private JTextField myKeywordsTextField;
    private TextFieldWithBrowseButton myTestScriptTextField;
    private JTextField myParamsTextField;
    private JBLabel myTargetLabel;
    private JCheckBox myParametersCheckBox;
    private JCheckBox myKeywordsCheckBox;
    private JPanel myRootPanel;
    private final AbstractPyCommonOptionsForm myCommonOptionsForm;
    private final Project myProject;
    private JComponent anchor;

    public PyTestConfigurationEditor(Project project, PyTestRunConfiguration configuration) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myCommonOptionsForm = PyCommonOptionsFormFactory.getInstance().createForm(configuration.getCommonOptionsFormData());
        this.myCommonOptionsPlaceholder.add(this.myCommonOptionsForm.getMainPanel());
        String title = PyBundle.message("runcfg.unittest.dlg.select.script.path", new Object[0]);
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileOrFolderDescriptor();
        fileChooserDescriptor.setTitle(title);
        this.myTestScriptTextField.addBrowseFolderListener(title, null, this.myProject, fileChooserDescriptor);
        this.myTargetLabel.setLabelFor((Component)this.myTestScriptTextField);
        this.myParametersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyTestConfigurationEditor.this.myParamsTextField.setEnabled(PyTestConfigurationEditor.this.myParametersCheckBox.isSelected());
            }
        });
        this.myKeywordsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PyTestConfigurationEditor.this.myKeywordsTextField.setEnabled(PyTestConfigurationEditor.this.myKeywordsCheckBox.isSelected());
            }
        });
        this.myParametersCheckBox.setSelected(configuration.useParam());
        this.myKeywordsCheckBox.setSelected(configuration.useKeyword());
        this.myParamsTextField.setEnabled(configuration.useParam());
        this.myKeywordsTextField.setEnabled(configuration.useKeyword());
        this.setAnchor(this.myCommonOptionsForm.getAnchor());
    }

    protected void resetEditorFrom(PyTestRunConfiguration s) {
        AbstractPythonRunConfiguration.copyParams(s, this.myCommonOptionsForm);
        this.myKeywordsTextField.setText(s.getKeywords());
        this.myTestScriptTextField.setText(s.getTestToRun());
        this.myKeywordsCheckBox.setSelected(s.useKeyword());
        this.myParametersCheckBox.setSelected(s.useParam());
        this.myParamsTextField.setText(s.getParams());
    }

    protected void applyEditorTo(PyTestRunConfiguration s) throws ConfigurationException {
        AbstractPythonRunConfiguration.copyParams(this.myCommonOptionsForm, s);
        s.setTestToRun(this.myTestScriptTextField.getText().trim());
        s.setKeywords(this.myKeywordsTextField.getText().trim());
        s.setParams(this.myParamsTextField.getText().trim());
        s.useKeyword(this.myKeywordsCheckBox.isSelected());
        s.useParam(this.myParametersCheckBox.isSelected());
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/pytest/PyTestConfigurationEditor", "createEditor"));
        }
        return jPanel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.myTargetLabel.setAnchor(anchor);
        this.myCommonOptionsForm.setAnchor(anchor);
    }

    @Override
    public boolean useParam() {
        return this.myParametersCheckBox.isSelected();
    }

    @Override
    public void useParam(boolean useParam) {
        this.myParametersCheckBox.setSelected(useParam);
    }

    @Override
    public boolean useKeyword() {
        return this.myKeywordsCheckBox.isSelected();
    }

    @Override
    public void useKeyword(boolean useKeyword) {
        this.myKeywordsCheckBox.setSelected(useKeyword);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JTextField jTextField;
        JTextField jTextField2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        this.myRootPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, "Card1");
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(-1, 200), null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"py.tests", (int)0, (int)0, null, null));
        this.myTargetLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.pytest.target"));
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(82, -1), null));
        this.myTestScriptTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText("Path to a file or directory that contains the tests to be executed");
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 1, null, new Dimension(341, 25), null));
        this.myKeywordsTextField = jTextField2 = new JTextField();
        jTextField2.setToolTipText("Specify the keywords to search for the required tests. -k command line option in py.tests");
        jPanel2.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(341, 25), null));
        this.myParamsTextField = jTextField = new JTextField();
        jTextField.setToolTipText("Specify py.tests command line options");
        jPanel2.add((Component)jTextField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(341, 25), null));
        this.myParametersCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.pytest.parameters"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myKeywordsCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("com/jetbrains/python/PyBundle").getString("runcfg.pytest.keywords"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, new Dimension(341, 14), null));
        this.myCommonOptionsPlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, new Dimension(-1, 10), null));
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

