/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.pytest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.pytest.PyTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PyTestRunConfiguration myConfiguration;
    private static final String PYTESTRUNNER_PY = "pycharm/pytestrunner.py";

    public PyTestCommandLineState(PyTestRunConfiguration configuration, ExecutionEnvironment env) {
        super(configuration, env);
        this.myConfiguration = configuration;
    }

    @Override
    protected void addBeforeParameters(GeneralCommandLine cmd) throws ExecutionException {
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        script_params.addParameters(new String[]{"-p", "pytest_teamcity"});
    }

    @Override
    protected String getRunner() {
        return PYTESTRUNNER_PY;
    }

    @Override
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        specs.add(this.myConfiguration.getTestToRun());
        return specs;
    }

    @Override
    protected void addAfterParameters(GeneralCommandLine cmd) throws ExecutionException {
        String keywords;
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        String params = this.myConfiguration.getParams();
        if (!StringUtil.isEmptyOrSpaces((String)params)) {
            script_params.addParametersString(params);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(keywords = this.myConfiguration.getKeywords()))) {
            script_params.addParameter("-k " + keywords);
        }
    }

    @Override
    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        ConsoleView consoleView = super.createAndAttachConsole(project, processHandler, executor);
        this.addTracebackFilter(project, consoleView, processHandler);
        ConsoleView consoleView2 = consoleView;
        if (consoleView2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/pytest/PyTestCommandLineState", "createAndAttachConsole"));
        }
        return consoleView2;
    }
}

