/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.nosetest;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testIntegration.TestLocationProvider;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PythonNoseTestUrlProvider
implements TestLocationProvider {
    @NonNls
    private static final String PROTOCOL_ID = "python_nosetestid";

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String path, Project project) {
        if (protocolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolId", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
        }
        if (!PROTOCOL_ID.equals(protocolId)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
            }
            return list;
        }
        List list = StringUtil.split((String)path, (String)".");
        if (list.isEmpty()) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
            }
            return list2;
        }
        int listSize = list.size();
        if (listSize == 2) {
            List<Location> classes = PythonUnitTestUtil.findLocations(project, (String)list.get(0), (String)list.get(1), null);
            if (classes.size() > 0) {
                List<Location> list3 = classes;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
                }
                return list3;
            }
            List<Location> functions = PythonUnitTestUtil.findLocations(project, (String)list.get(0), null, (String)list.get(1));
            if (functions.size() > 0) {
                List<Location> list4 = functions;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
                }
                return list4;
            }
        }
        if (listSize > 2) {
            String className = (String)list.get(listSize - 2);
            String methodName = (String)list.get(listSize - 1);
            String fileName = (String)list.get(listSize - 3);
            List<Location> locations = PythonUnitTestUtil.findLocations(project, fileName, className, methodName);
            if (locations.size() > 0) {
                List<Location> list5 = locations;
                if (list5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
                }
                return list5;
            }
            locations = PythonUnitTestUtil.findLocations(project, (String)list.get(listSize - 2), (String)list.get(listSize - 1), null);
            if (locations.size() > 0) {
                List<Location> list6 = locations;
                if (list6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
                }
                return list6;
            }
            List<Location> functions = PythonUnitTestUtil.findLocations(project, (String)list.get(listSize - 2), null, (String)list.get(listSize - 1));
            if (functions.size() > 0) {
                List<Location> list7 = functions;
                if (list7 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
                }
                return list7;
            }
        }
        List<Location> list8 = PythonUnitTestUtil.findLocations(project, project.getBasePath() + "/" + StringUtil.join((Collection)list, (String)"/") + ".py", null, null);
        if (list8 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/nosetest/PythonNoseTestUrlProvider", "getLocation"));
        }
        return list8;
    }
}

