/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.nosetest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import com.jetbrains.python.testing.nosetest.PythonNoseTestCommandLineState;
import com.jetbrains.python.testing.nosetest.PythonNoseTestRunConfigurationEditor;
import com.jetbrains.python.testing.nosetest.PythonNoseTestRunConfigurationParams;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PythonNoseTestRunConfiguration
extends AbstractPythonTestRunConfiguration
implements PythonNoseTestRunConfigurationParams {
    private String myParams = "";
    protected String myTitle = "Nosetest";
    protected String myPluralTitle = "Nosetests";
    private boolean useParam = false;

    public PythonNoseTestRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        return new PythonNoseTestRunConfigurationEditor(this.getProject(), this);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        PathMacroManager.getInstance((ComponentManager)this.getProject()).expandPaths(element);
        super.readExternal(element);
        this.myParams = JDOMExternalizerUtil.readField((Element)element, (String)"PARAMS");
        this.useParam = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_PARAM"));
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"PARAMS", (String)this.myParams);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_PARAM", (String)String.valueOf(this.useParam));
        PathMacroManager.getInstance((ComponentManager)this.getProject()).collapsePathsRecursively(element);
    }

    @Override
    protected String getTitle() {
        return this.myTitle;
    }

    @Override
    protected String getPluralTitle() {
        return this.myPluralTitle;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/testing/nosetest/PythonNoseTestRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/testing/nosetest/PythonNoseTestRunConfiguration", "getState"));
        }
        return new PythonNoseTestCommandLineState(this, env);
    }

    public static void copyParams(PythonNoseTestRunConfigurationParams source, PythonNoseTestRunConfigurationParams target) {
        AbstractPythonTestRunConfiguration.copyParams(source.getTestRunConfigurationParams(), target.getTestRunConfigurationParams());
        target.setParams(source.getParams());
        target.useParam(source.useParam());
    }

    @Override
    public String getParams() {
        return this.myParams;
    }

    @Override
    public void setParams(String pattern) {
        this.myParams = pattern;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        Sdk sdkPath = PythonSdkType.findSdkByPath(this.getInterpreterPath());
        if (sdkPath != null && !VFSTestFrameworkListener.getInstance().isNoseTestInstalled(sdkPath)) {
            throw new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", "nosetest"));
        }
    }

    @Override
    public boolean useParam() {
        return this.useParam;
    }

    @Override
    public void useParam(boolean useParam) {
        this.useParam = useParam;
    }
}

