/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.nosetest;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestConfigurationProducer;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.testing.TestRunnerService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonNoseTestConfigurationProducer
extends PythonTestConfigurationProducer {
    public PythonNoseTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().PY_NOSETEST_FACTORY);
    }

    @Override
    protected boolean isAvailable(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/testing/nosetest/PythonNoseTestConfigurationProducer", "isAvailable"));
        }
        PsiElement element = location.getPsiElement();
        Module module = location.getModule();
        if (module == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length == 0) {
                return false;
            }
            module = modules[0];
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module);
        return PythonTestConfigurationsModel.PYTHONS_NOSETEST_NAME.equals(TestRunnerService.getInstance(module).getProjectConfiguration()) && sdk != null;
    }

    @Override
    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/testing/nosetest/PythonNoseTestConfigurationProducer", "isTestFunction"));
        }
        return PythonUnitTestUtil.isTestCaseFunction(pyFunction, true);
    }
}

