/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.nosetest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.nosetest.PythonNoseTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;

public class PythonNoseTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PythonNoseTestRunConfiguration myConfig;
    private static final String NOSERUNNER_PY = "pycharm/noserunner.py";

    public PythonNoseTestCommandLineState(PythonNoseTestRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected String getRunner() {
        return NOSERUNNER_PY;
    }

    @Override
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String scriptName = FileUtil.toSystemDependentName((String)this.myConfig.getScriptName());
        switch (this.myConfig.getTestType()) {
            case TEST_SCRIPT: {
                specs.add(scriptName);
                break;
            }
            case TEST_CLASS: {
                specs.add(scriptName + "::" + this.myConfig.getClassName());
                break;
            }
            case TEST_METHOD: {
                specs.add(scriptName + "::" + this.myConfig.getClassName() + "::" + this.myConfig.getMethodName());
                break;
            }
            case TEST_FOLDER: {
                specs.add(FileUtil.toSystemDependentName((String)(this.myConfig.getFolderName() + "/")));
                break;
            }
            case TEST_FUNCTION: {
                specs.add(scriptName + "::::" + this.myConfig.getMethodName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test type: " + (Object)((Object)this.myConfig.getTestType()));
            }
        }
        return specs;
    }

    @Override
    protected void addAfterParameters(GeneralCommandLine cmd) throws ExecutionException {
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        if (this.myConfig.useParam() && !StringUtil.isEmptyOrSpaces((String)this.myConfig.getParams())) {
            script_params.addParametersString(this.myConfig.getParams());
        }
    }
}

