/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.doctest;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestConfigurationProducer;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.doctest.PythonDocTestUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonDocTestConfigurationProducer
extends PythonTestConfigurationProducer {
    public PythonDocTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().PY_DOCTEST_FACTORY);
    }

    @Override
    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer", "isTestFunction"));
        }
        return PythonDocTestUtil.isDocTestFunction(pyFunction);
    }

    @Override
    protected boolean isTestClass(@NotNull PyClass pyClass, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer", "isTestClass"));
        }
        return PythonDocTestUtil.isDocTestClass(pyClass);
    }

    @Override
    protected boolean isTestFile(@NotNull PyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer", "isTestFile"));
        }
        List<PyElement> testCases = PythonDocTestUtil.getDocTestCasesFromFile(file);
        return !testCases.isEmpty();
    }

    @Override
    protected boolean isAvailable(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer", "isAvailable"));
        }
        Module module = location.getModule();
        if (!PythonDocTestConfigurationProducer.isPythonModule(module)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiFile) {
            PyDocTestVisitor visitor = new PyDocTestVisitor();
            element.accept((PsiElementVisitor)visitor);
            return visitor.hasTests;
        }
        return true;
    }

    @Override
    protected boolean isTestFolder(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer", "isTestFolder"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/testing/doctest/PythonDocTestConfigurationProducer", "isTestFolder"));
        }
        return false;
    }

    private static class PyDocTestVisitor
    extends PsiRecursiveElementVisitor {
        boolean hasTests = false;

        private PyDocTestVisitor() {
        }

        public void visitFile(PsiFile node) {
            if (node instanceof PyFile) {
                List<PyElement> testClasses = PythonDocTestUtil.getDocTestCasesFromFile((PyFile)node);
                if (!testClasses.isEmpty()) {
                    this.hasTests = true;
                }
            } else {
                String text = node.getText();
                if (PythonDocTestUtil.hasExample(text)) {
                    this.hasTests = true;
                }
            }
        }
    }
}

