/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.doctest;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.doctest.PythonDocTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;

public class PythonDocTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PythonDocTestRunConfiguration myConfig;
    private static final String UTRUNNER_PY = "pycharm/docrunner.py";

    public PythonDocTestCommandLineState(PythonDocTestRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected String getRunner() {
        return UTRUNNER_PY;
    }

    @Override
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        switch (this.myConfig.getTestType()) {
            case TEST_SCRIPT: {
                specs.add(this.myConfig.getScriptName());
                break;
            }
            case TEST_CLASS: {
                specs.add(this.myConfig.getScriptName() + "::" + this.myConfig.getClassName());
                break;
            }
            case TEST_METHOD: {
                specs.add(this.myConfig.getScriptName() + "::" + this.myConfig.getClassName() + "::" + this.myConfig.getMethodName());
                break;
            }
            case TEST_FOLDER: {
                if (!this.myConfig.getPattern().isEmpty()) {
                    specs.add(this.myConfig.getFolderName() + "/" + ";" + this.myConfig.getPattern());
                    break;
                }
                specs.add(this.myConfig.getFolderName() + "/");
                break;
            }
            case TEST_FUNCTION: {
                specs.add(this.myConfig.getScriptName() + "::::" + this.myConfig.getMethodName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test type: " + (Object)((Object)this.myConfig.getTestType()));
            }
        }
        return specs;
    }
}

