/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.attest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import com.jetbrains.python.testing.attest.PythonAtTestCommandLineState;
import com.jetbrains.python.testing.attest.PythonAtTestRunConfigurationEditor;
import com.jetbrains.python.testing.attest.PythonAtTestRunConfigurationParams;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PythonAtTestRunConfiguration
extends AbstractPythonTestRunConfiguration
implements PythonAtTestRunConfigurationParams {
    protected String myTitle = "Attest";
    protected String myPluralTitle = "Attests";

    public PythonAtTestRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    protected SettingsEditor<? extends RunConfiguration> createConfigurationEditor() {
        return new PythonAtTestRunConfigurationEditor(this.getProject(), this);
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executor", "com/jetbrains/python/testing/attest/PythonAtTestRunConfiguration", "getState"));
        }
        if (env == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/jetbrains/python/testing/attest/PythonAtTestRunConfiguration", "getState"));
        }
        return new PythonAtTestCommandLineState(this, env);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
    }

    @Override
    protected String getTitle() {
        return this.myTitle;
    }

    @Override
    protected String getPluralTitle() {
        return this.myPluralTitle;
    }

    public static void copyParams(PythonAtTestRunConfigurationParams source, PythonAtTestRunConfigurationParams target) {
        PythonAtTestRunConfiguration.copyParams(source.getTestRunConfigurationParams(), target.getTestRunConfigurationParams());
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        Sdk sdkPath = PythonSdkType.findSdkByPath(this.getInterpreterPath());
        if (sdkPath != null && !VFSTestFrameworkListener.getInstance().isAtTestInstalled(sdkPath)) {
            throw new RuntimeConfigurationWarning(PyBundle.message("runcfg.testing.no.test.framework", "attest"));
        }
    }
}

