/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.attest;

import com.google.common.collect.Lists;
import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonTestConfigurationProducer;
import com.jetbrains.python.testing.PythonTestConfigurationType;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerService;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonAtTestConfigurationProducer
extends PythonTestConfigurationProducer {
    public PythonAtTestConfigurationProducer() {
        super(PythonTestConfigurationType.getInstance().PY_ATTEST_FACTORY);
    }

    @Override
    protected boolean isAvailable(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/testing/attest/PythonAtTestConfigurationProducer", "isAvailable"));
        }
        PsiElement element = location.getPsiElement();
        Module module = location.getModule();
        if (module == null) {
            module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module);
        return module != null && TestRunnerService.getInstance(module).getProjectConfiguration().equals(PythonTestConfigurationsModel.PYTHONS_ATTEST_NAME) && sdk != null;
    }

    @Override
    protected boolean isTestClass(@NotNull PyClass pyClass, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/testing/attest/PythonAtTestConfigurationProducer", "isTestClass"));
        }
        for (PyClassLikeType type : pyClass.getAncestorTypes(TypeEvalContext.codeInsightFallback(pyClass.getProject()))) {
            if (type == null || !"TestBase".equals(type.getName()) || !PythonAtTestConfigurationProducer.hasTestFunction(pyClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasTestFunction(@NotNull PyClass pyClass) {
        PyFunction[] methods;
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/testing/attest/PythonAtTestConfigurationProducer", "hasTestFunction"));
        }
        for (PyFunction function : methods = pyClass.getMethods(false)) {
            PyDecoratorList decorators = function.getDecoratorList();
            if (decorators == null) continue;
            for (PyDecorator decorator : decorators.getDecorators()) {
                if (!"test".equals(decorator.getName()) && !"test_if".equals(decorator.getName())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/testing/attest/PythonAtTestConfigurationProducer", "isTestFunction"));
        }
        PyDecoratorList decorators = pyFunction.getDecoratorList();
        if (decorators == null) {
            return false;
        }
        for (PyDecorator decorator : decorators.getDecorators()) {
            if (!"test".equals(decorator.getName()) && !"test_if".equals(decorator.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected List<PyStatement> getTestCaseClassesFromFile(@NotNull PyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/testing/attest/PythonAtTestConfigurationProducer", "getTestCaseClassesFromFile"));
        }
        ArrayList result = Lists.newArrayList();
        for (PyClass pyClass : file.getTopLevelClasses()) {
            if (!this.isTestClass(pyClass, null)) continue;
            result.add(pyClass);
        }
        for (PyFunction pyFunction : file.getTopLevelFunctions()) {
            if (!this.isTestFunction(pyFunction, null)) continue;
            result.add(pyFunction);
        }
        return result;
    }
}

