/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing.attest;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.python.testing.PythonTestCommandLineStateBase;
import com.jetbrains.python.testing.attest.PythonAtTestRunConfiguration;
import java.util.ArrayList;
import java.util.List;

public class PythonAtTestCommandLineState
extends PythonTestCommandLineStateBase {
    private final PythonAtTestRunConfiguration myConfig;
    private static final String UTRUNNER_PY = "pycharm/attestrunner.py";

    public PythonAtTestCommandLineState(PythonAtTestRunConfiguration runConfiguration, ExecutionEnvironment env) {
        super(runConfiguration, env);
        this.myConfig = runConfiguration;
    }

    @Override
    protected String getRunner() {
        return UTRUNNER_PY;
    }

    @Override
    protected List<String> getTestSpecs() {
        ArrayList<String> specs = new ArrayList<String>();
        String scriptName = FileUtil.toSystemDependentName((String)this.myConfig.getScriptName());
        switch (this.myConfig.getTestType()) {
            case TEST_SCRIPT: {
                specs.add(scriptName);
                break;
            }
            case TEST_CLASS: {
                specs.add(scriptName + "::" + this.myConfig.getClassName());
                break;
            }
            case TEST_METHOD: {
                specs.add(scriptName + "::" + this.myConfig.getClassName() + "::" + this.myConfig.getMethodName());
                break;
            }
            case TEST_FOLDER: {
                String folderName = FileUtil.toSystemDependentName((String)(this.myConfig.getFolderName() + "/"));
                if (!this.myConfig.getPattern().isEmpty()) {
                    specs.add(folderName + ";" + this.myConfig.getPattern());
                    break;
                }
                specs.add(folderName);
                break;
            }
            case TEST_FUNCTION: {
                specs.add(scriptName + "::::" + this.myConfig.getMethodName());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown test type: " + (Object)((Object)this.myConfig.getTestType()));
            }
        }
        return specs;
    }
}

