/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.PyTestFrameworkService;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VFSTestFrameworkListener
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.python.testing.VFSTestFrameworkListener");
    private static final MergingUpdateQueue myQueue = new MergingUpdateQueue("TestFrameworkChecker", 5000, true, null);
    private PyTestFrameworkService myService = PyTestFrameworkService.getInstance();

    public VFSTestFrameworkListener() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        messageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener.Adapter(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                if (events == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/jetbrains/python/testing/VFSTestFrameworkListener$1", "after"));
                }
                for (VFileEvent vFileEvent : events) {
                    if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem) || vFileEvent instanceof VFileContentChangeEvent) continue;
                    String path = vFileEvent.getPath();
                    boolean containsNose = path.contains("nose");
                    boolean containsPy = path.contains("py-1") || path.contains("pytest");
                    boolean containsAt = path.contains("Attest");
                    if (!containsAt && !containsNose && !containsPy) continue;
                    for (Sdk sdk : PythonSdkType.getAllSdks()) {
                        if (PySdkUtil.isRemote(sdk)) continue;
                        for (VirtualFile virtualFile : sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
                            String root = virtualFile.getCanonicalPath();
                            if (root == null || !path.contains(root)) continue;
                            if (containsNose) {
                                VFSTestFrameworkListener.this.updateTestFrameworks(sdk, "nose");
                                return;
                            }
                            if (containsPy) {
                                VFSTestFrameworkListener.this.updateTestFrameworks(sdk, "pytest");
                                return;
                            }
                            VFSTestFrameworkListener.this.updateTestFrameworks(sdk, "Attest");
                            return;
                        }
                    }
                }
            }
        });
    }

    public void updateAllTestFrameworks(Sdk sdk) {
        this.updateTestFrameworks(sdk, "pytest");
        this.updateTestFrameworks(sdk, "nose");
        this.updateTestFrameworks(sdk, "Attest");
        myQueue.flush();
    }

    public void updateTestFrameworks(final Sdk sdk, final String testPackageName) {
        myQueue.queue(new Update(Pair.create((Object)sdk, (Object)testPackageName)){

            public void run() {
                Boolean installed = VFSTestFrameworkListener.isTestFrameworkInstalled(sdk, testPackageName);
                if (installed != null) {
                    VFSTestFrameworkListener.this.testInstalled(installed, sdk.getHomePath(), testPackageName);
                }
            }
        });
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    @NotNull
    public String getComponentName() {
        if ("VFSTestFrameworkListener" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/VFSTestFrameworkListener", "getComponentName"));
        }
        return "VFSTestFrameworkListener";
    }

    public static Boolean isTestFrameworkInstalled(Sdk sdk, String testPackageName) {
        if (sdk == null || StringUtil.isEmptyOrSpaces((String)sdk.getHomePath())) {
            LOG.info("Searching test runner in empty sdk");
            return null;
        }
        PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
        try {
            return packageManager.findPackage(testPackageName, false) != null;
        }
        catch (ExecutionException e) {
            LOG.info("Can't load package list " + e.getMessage());
            return null;
        }
    }

    public static VFSTestFrameworkListener getInstance() {
        return (VFSTestFrameworkListener)ServiceManager.getService(VFSTestFrameworkListener.class);
    }

    public void pyTestInstalled(boolean installed, String sdkHome) {
        this.myService.SDK_TO_PYTEST.put(sdkHome, installed);
    }

    public boolean isPyTestInstalled(Sdk sdk) {
        Boolean isInstalled = this.myService.SDK_TO_PYTEST.get(sdk.getHomePath());
        if (isInstalled == null) {
            this.updateTestFrameworks(sdk, "pytest");
            return true;
        }
        return isInstalled;
    }

    public void noseTestInstalled(boolean installed, String sdkHome) {
        this.myService.SDK_TO_NOSETEST.put(sdkHome, installed);
    }

    public boolean isNoseTestInstalled(Sdk sdk) {
        Boolean isInstalled = this.myService.SDK_TO_NOSETEST.get(sdk.getHomePath());
        if (isInstalled == null) {
            this.updateTestFrameworks(sdk, "nose");
            return true;
        }
        return isInstalled;
    }

    public void atTestInstalled(boolean installed, String sdkHome) {
        this.myService.SDK_TO_ATTEST.put(sdkHome, installed);
    }

    public boolean isAtTestInstalled(Sdk sdk) {
        Boolean isInstalled = this.myService.SDK_TO_ATTEST.get(sdk.getHomePath());
        if (isInstalled == null) {
            this.updateTestFrameworks(sdk, "Attest");
            return true;
        }
        return isInstalled;
    }

    public void testInstalled(boolean installed, String sdkHome, String name) {
        if (name.equals("nose")) {
            this.noseTestInstalled(installed, sdkHome);
        } else if (name.equals("pytest")) {
            this.pyTestInstalled(installed, sdkHome);
        } else if (name.equals("Attest")) {
            this.atTestInstalled(installed, sdkHome);
        }
    }
}

