/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.psi.PyAssertStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyYieldExpression;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import com.jetbrains.python.psi.stubs.PyFunctionNameIndex;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonUnitTestUtil {
    public static final String TESTCASE_SETUP_NAME = "setUp";
    private static final HashSet<String> PYTHON_TEST_QUALIFIED_CLASSES = Sets.newHashSet((Object[])new String[]{"unittest.TestCase", "unittest.case.TestCase"});
    private static final Pattern TEST_MATCH_PATTERN = Pattern.compile("(?:^|[\b_\\.%s-])[Tt]est");
    private static final String TESTCASE_METHOD_PREFIX = "test";

    private PythonUnitTestUtil() {
    }

    public static boolean isUnitTestCaseFunction(PyFunction function) {
        String name = function.getName();
        if (name == null || !name.startsWith(TESTCASE_METHOD_PREFIX)) {
            return false;
        }
        PyClass containingClass = function.getContainingClass();
        return containingClass != null && PythonUnitTestUtil.isUnitTestCaseClass(containingClass, PYTHON_TEST_QUALIFIED_CLASSES);
    }

    public static boolean isUnitTestCaseClass(PyClass cls) {
        return PythonUnitTestUtil.isUnitTestCaseClass(cls, PYTHON_TEST_QUALIFIED_CLASSES);
    }

    public static boolean isUnitTestFile(PyFile file) {
        return file.getName().startsWith(TESTCASE_METHOD_PREFIX);
    }

    private static boolean isUnitTestCaseClass(PyClass cls, HashSet<String> testQualifiedNames) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (PyExpression expression : cls.getSuperClassExpressions()) {
                if (!expression.getText().equals("TestCase")) continue;
                return true;
            }
        }
        for (PyClassLikeType type : cls.getAncestorTypes(TypeEvalContext.codeInsightFallback(cls.getProject()))) {
            if (type == null || !testQualifiedNames.contains(type.getClassQName())) continue;
            return true;
        }
        return false;
    }

    public static List<PyStatement> getTestCaseClassesFromFile(PsiFile file) {
        if (file instanceof PyFile) {
            return PythonUnitTestUtil.getTestCaseClassesFromFile((PyFile)file, PYTHON_TEST_QUALIFIED_CLASSES);
        }
        return Collections.emptyList();
    }

    public static List<PyStatement> getTestCaseClassesFromFile(PyFile file, Set<String> testQualifiedNames) {
        ArrayList result = Lists.newArrayList();
        for (PyClass pyClass : file.getTopLevelClasses()) {
            if (!PythonUnitTestUtil.isTestCaseClass(pyClass, testQualifiedNames)) continue;
            result.add(pyClass);
        }
        for (PyFunction pyFunction : file.getTopLevelFunctions()) {
            if (!PythonUnitTestUtil.isTestCaseFunction(pyFunction, false)) continue;
            result.add(pyFunction);
        }
        return result;
    }

    public static boolean isTestCaseFunction(PyFunction function) {
        return PythonUnitTestUtil.isTestCaseFunction(function, true);
    }

    public static boolean isTestCaseFunction(PyFunction function, boolean checkAssert) {
        boolean hasAssert;
        String name = function.getName();
        if (name == null || !TEST_MATCH_PATTERN.matcher(name).find()) {
            return false;
        }
        if (function.getContainingClass() != null && PythonUnitTestUtil.isTestCaseClass(function.getContainingClass())) {
            return true;
        }
        return checkAssert && (hasAssert = PythonUnitTestUtil.hasAssertOrYield(function.getStatementList()));
    }

    private static boolean hasAssertOrYield(PyStatementList list) {
        Stack stack = new Stack();
        if (list != null) {
            for (PyStatement st : list.getStatements()) {
                stack.push((Object)st);
                while (!stack.isEmpty()) {
                    PsiElement e = (PsiElement)stack.pop();
                    if (e instanceof PyAssertStatement || e instanceof PyYieldExpression) {
                        return true;
                    }
                    for (PsiElement psiElement : e.getChildren()) {
                        stack.push((Object)psiElement);
                    }
                }
            }
        }
        return false;
    }

    public static boolean isTestCaseClass(@NotNull PyClass cls) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/testing/PythonUnitTestUtil", "isTestCaseClass"));
        }
        return PythonUnitTestUtil.isTestCaseClass(cls, PYTHON_TEST_QUALIFIED_CLASSES);
    }

    public static boolean isTestCaseClass(@NotNull PyClass cls, Set<String> testQualifiedNames) {
        if (cls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/jetbrains/python/testing/PythonUnitTestUtil", "isTestCaseClass"));
        }
        for (PyClassLikeType type : cls.getAncestorTypes(TypeEvalContext.codeInsightFallback(cls.getProject()))) {
            if (type == null) continue;
            if (testQualifiedNames.contains(type.getClassQName())) {
                return true;
            }
            String clsName = cls.getQualifiedName();
            String[] names = new String[]{};
            if (clsName != null) {
                names = clsName.split("\\.");
            }
            if (names.length == 0) {
                return false;
            }
            clsName = names[names.length - 1];
            if (!TEST_MATCH_PATTERN.matcher(clsName).find()) continue;
            return true;
        }
        return false;
    }

    public static List<Location> findLocations(@NotNull Project project, @NotNull String fileName, @Nullable String className, @Nullable String methodName) {
        ArrayList<Location> locations;
        block10: {
            block9: {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/testing/PythonUnitTestUtil", "findLocations"));
                }
                if (fileName == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/jetbrains/python/testing/PythonUnitTestUtil", "findLocations"));
                }
                if (fileName.contains("%")) {
                    fileName = fileName.substring(0, fileName.lastIndexOf("%"));
                }
                locations = new ArrayList<Location>();
                if (methodName == null && className == null) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(fileName);
                    if (virtualFile == null) {
                        return locations;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
                    if (psiFile != null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)psiFile));
                    }
                }
                if (className == null) break block9;
                for (PyClass cls : PyClassNameIndex.find(className, project, false)) {
                    ProgressManager.checkCanceled();
                    PsiFile containingFile = cls.getContainingFile();
                    VirtualFile virtualFile = containingFile.getVirtualFile();
                    String clsFileName = virtualFile == null ? containingFile.getName() : virtualFile.getPath();
                    String clsFileNameWithoutExt = FileUtil.getNameWithoutExtension((String)clsFileName);
                    if (!clsFileNameWithoutExt.endsWith(fileName)) continue;
                    if (methodName == null) {
                        locations.add((Location)new PsiLocation(project, (PsiElement)cls));
                        continue;
                    }
                    PyFunction method = cls.findMethodByName(methodName, true);
                    if (method == null) continue;
                    locations.add((Location)new PsiLocation(project, (PsiElement)method));
                }
                break block10;
            }
            if (methodName == null) break block10;
            for (PyFunction function : PyFunctionNameIndex.find(methodName, project)) {
                PsiFile containingFile;
                VirtualFile virtualFile;
                String clsFileName;
                String clsFileNameWithoutExt;
                ProgressManager.checkCanceled();
                if (function.getContainingClass() != null || !(clsFileNameWithoutExt = FileUtil.getNameWithoutExtension((String)(clsFileName = (virtualFile = (containingFile = function.getContainingFile()).getVirtualFile()) == null ? containingFile.getName() : virtualFile.getPath()))).endsWith(fileName)) continue;
                locations.add((Location)new PsiLocation(project, (PsiElement)function));
            }
        }
        return locations;
    }
}

