/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testIntegration.TestLocationProvider;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PythonUnitTestTestIdUrlProvider
implements TestLocationProvider {
    @NonNls
    private static final String PROTOCOL_ID = "python_uttestid";

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocolId, @NotNull String path, Project project) {
        if (protocolId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "protocolId", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
        }
        if (!PROTOCOL_ID.equals(protocolId)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
            }
            return list;
        }
        List list = StringUtil.split((String)path, (String)".");
        if (list.isEmpty()) {
            List<Location> list2 = Collections.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
            }
            return list2;
        }
        int listSize = list.size();
        if (listSize == 2) {
            List<Location> list3 = PythonUnitTestUtil.findLocations(project, (String)list.get(0), (String)list.get(1), null);
            if (list3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
            }
            return list3;
        }
        if (listSize > 2) {
            String className = (String)list.get(listSize - 2);
            String methodName = (String)list.get(listSize - 1);
            String fileName = (String)list.get(listSize - 3);
            List<Location> locations = PythonUnitTestUtil.findLocations(project, fileName, className, methodName);
            if (locations.size() > 0) {
                List<Location> list4 = locations;
                if (list4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
                }
                return list4;
            }
            List<Location> list5 = PythonUnitTestUtil.findLocations(project, (String)list.get(listSize - 2), (String)list.get(listSize - 1), null);
            if (list5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
            }
            return list5;
        }
        List<Location> list6 = Collections.emptyList();
        if (list6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonUnitTestTestIdUrlProvider", "getLocation"));
        }
        return list6;
    }
}

