/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.Location;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.run.RunnableScriptFilter;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.testing.TestRunnerService;
import org.jetbrains.annotations.NotNull;

public class PythonUnitTestRunnableScriptFilter
implements RunnableScriptFilter {
    @Override
    public boolean isRunnableScript(PsiFile script, @NotNull Module module, Location location) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/jetbrains/python/testing/PythonUnitTestRunnableScriptFilter", "isRunnableScript"));
        }
        return script instanceof PyFile && PythonUnitTestUtil.getTestCaseClassesFromFile(script).size() > 0 && !PythonUnitTestRunnableScriptFilter.isIfNameMain(location) && TestRunnerService.getInstance(module).getProjectConfiguration().equals(PythonTestConfigurationsModel.PYTHONS_UNITTEST_NAME);
    }

    public static boolean isIfNameMain(Location location) {
        PyIfStatement ifStatement;
        Object element = location.getPsiElement();
        while ((ifStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PyIfStatement.class)) != null) {
            element = ifStatement;
        }
        if (element instanceof PyIfStatement) {
            ifStatement = (PyIfStatement)element;
            return PyUtil.isIfNameEqualsMain(ifStatement);
        }
        return false;
    }
}

