/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.run.PythonConfigurationFactoryBase;
import com.jetbrains.python.testing.attest.PythonAtTestRunConfiguration;
import com.jetbrains.python.testing.doctest.PythonDocTestRunConfiguration;
import com.jetbrains.python.testing.nosetest.PythonNoseTestRunConfiguration;
import com.jetbrains.python.testing.pytest.PyTestRunConfiguration;
import com.jetbrains.python.testing.unittest.PythonUnitTestRunConfiguration;
import icons.PythonIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PythonTestConfigurationType
implements ConfigurationType {
    public static final String ID = "tests";
    public final PythonDocTestConfigurationFactory PY_DOCTEST_FACTORY = new PythonDocTestConfigurationFactory(this);
    public final PythonUnitTestConfigurationFactory PY_UNITTEST_FACTORY = new PythonUnitTestConfigurationFactory(this);
    public final PythonNoseTestConfigurationFactory PY_NOSETEST_FACTORY = new PythonNoseTestConfigurationFactory(this);
    public final PythonPyTestConfigurationFactory PY_PYTEST_FACTORY = new PythonPyTestConfigurationFactory(this);
    public final PythonAtTestConfigurationFactory PY_ATTEST_FACTORY = new PythonAtTestConfigurationFactory(this);

    public static PythonTestConfigurationType getInstance() {
        return (PythonTestConfigurationType)ConfigurationTypeUtil.findConfigurationType(PythonTestConfigurationType.class);
    }

    public String getDisplayName() {
        return PyBundle.message("runcfg.test.display_name", new Object[0]);
    }

    public String getConfigurationTypeDescription() {
        return PyBundle.message("runcfg.test.description", new Object[0]);
    }

    public Icon getIcon() {
        return PythonIcons.Python.PythonTests;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonTestConfigurationType", "getId"));
        }
        return ID;
    }

    public ConfigurationFactory[] getConfigurationFactories() {
        return new ConfigurationFactory[]{this.PY_UNITTEST_FACTORY, this.PY_DOCTEST_FACTORY, this.PY_NOSETEST_FACTORY, this.PY_PYTEST_FACTORY, this.PY_ATTEST_FACTORY};
    }

    private static class PythonAtTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonAtTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonAtTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.attest.display_name", new Object[0]);
        }
    }

    private static class PythonNoseTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonNoseTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonNoseTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.nosetests.display_name", new Object[0]);
        }
    }

    private static class PythonPyTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonPyTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PyTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.pytest.display_name", new Object[0]);
        }
    }

    private static class PythonDocTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonDocTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonDocTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.doctest.display_name", new Object[0]);
        }
    }

    private static class PythonUnitTestConfigurationFactory
    extends PythonConfigurationFactoryBase {
        protected PythonUnitTestConfigurationFactory(ConfigurationType configurationType) {
            super(configurationType);
        }

        public RunConfiguration createTemplateConfiguration(Project project) {
            return new PythonUnitTestRunConfiguration(project, this);
        }

        public String getName() {
            return PyBundle.message("runcfg.unittest.display_name", new Object[0]);
        }
    }
}

