/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.Sets;
import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.facet.PythonFacetSettings;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.run.PythonRunConfigurationProducer;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PythonUnitTestRunnableScriptFilter;
import com.jetbrains.python.testing.PythonUnitTestUtil;
import com.jetbrains.python.testing.unittest.PythonUnitTestRunConfiguration;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PythonTestConfigurationProducer
extends RunConfigurationProducer<AbstractPythonTestRunConfiguration> {
    public PythonTestConfigurationProducer(ConfigurationFactory configurationFactory) {
        super(configurationFactory);
    }

    public boolean isConfigurationFromContext(AbstractPythonTestRunConfiguration configuration, ConfigurationContext context) {
        String path;
        boolean isTestFileEquals;
        VirtualFile virtualFile;
        Location location = context.getLocation();
        if (location == null || !this.isAvailable(location)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        PsiFile file = element.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = element instanceof PsiDirectory ? ((PsiDirectory)element).getVirtualFile() : file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
        AbstractPythonTestRunConfiguration.TestType confType = configuration.getTestType();
        String workingDirectory = configuration.getWorkingDirectory();
        if (element instanceof PsiDirectory) {
            String path2 = ((PsiDirectory)element).getVirtualFile().getPath();
            return confType == AbstractPythonTestRunConfiguration.TestType.TEST_FOLDER && path2.equals(configuration.getFolderName()) || path2.equals(new File(workingDirectory, configuration.getFolderName()).getAbsolutePath());
        }
        String scriptName = configuration.getScriptName();
        boolean bl = isTestFileEquals = scriptName.equals(path = virtualFile.getPath()) || path.equals(new File(workingDirectory, scriptName).getAbsolutePath());
        if (pyFunction != null) {
            String methodName = configuration.getMethodName();
            if (pyFunction.getContainingClass() == null) {
                return confType == AbstractPythonTestRunConfiguration.TestType.TEST_FUNCTION && methodName.equals(pyFunction.getName()) && isTestFileEquals;
            }
            String className = configuration.getClassName();
            return confType == AbstractPythonTestRunConfiguration.TestType.TEST_METHOD && methodName.equals(pyFunction.getName()) && pyClass != null && className.equals(pyClass.getName()) && isTestFileEquals;
        }
        if (pyClass != null) {
            String className = configuration.getClassName();
            return confType == AbstractPythonTestRunConfiguration.TestType.TEST_CLASS && className.equals(pyClass.getName()) && isTestFileEquals;
        }
        return confType == AbstractPythonTestRunConfiguration.TestType.TEST_SCRIPT && isTestFileEquals;
    }

    protected boolean setupConfigurationFromContext(AbstractPythonTestRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        if (context == null) {
            return false;
        }
        Location location = context.getLocation();
        if (location == null || !this.isAvailable(location)) {
            return false;
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiWhiteSpace) {
            element = PyUtil.findNonWhitespaceAtOffset(element.getContainingFile(), element.getTextOffset());
        }
        if (PythonUnitTestRunnableScriptFilter.isIfNameMain(location)) {
            return false;
        }
        Module module = location.getModule();
        if (!PythonTestConfigurationProducer.isPythonModule(module)) {
            return false;
        }
        if (element instanceof PsiDirectory) {
            return this.setupConfigurationFromFolder((PsiDirectory)element, configuration);
        }
        PyFunction pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)element, PyFunction.class, (boolean)false);
        if (pyFunction != null && this.isTestFunction(pyFunction, configuration)) {
            return this.setupConfigurationFromFunction(pyFunction, configuration);
        }
        PyClass pyClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class, (boolean)false);
        if (pyClass != null && this.isTestClass(pyClass, configuration)) {
            return this.setupConfigurationFromClass(pyClass, configuration);
        }
        if (element == null) {
            return false;
        }
        PsiFile file = element.getContainingFile();
        if (file instanceof PyFile && this.isTestFile((PyFile)file)) {
            return this.setupConfigurationFromFile((PyFile)file, configuration);
        }
        return false;
    }

    private boolean setupConfigurationFromFolder(@NotNull PsiDirectory element, @NotNull AbstractPythonTestRunConfiguration configuration) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromFolder"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromFolder"));
        }
        VirtualFile virtualFile = element.getVirtualFile();
        if (!this.isTestFolder(virtualFile, element.getProject())) {
            return false;
        }
        String path = virtualFile.getPath();
        configuration.setTestType(AbstractPythonTestRunConfiguration.TestType.TEST_FOLDER);
        configuration.setFolderName(path);
        configuration.setWorkingDirectory(path);
        configuration.setGeneratedName();
        PythonTestConfigurationProducer.setModuleSdk((PsiElement)element, configuration);
        return true;
    }

    private static void setModuleSdk(@NotNull PsiElement element, @NotNull AbstractPythonTestRunConfiguration configuration) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setModuleSdk"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setModuleSdk"));
        }
        configuration.setUseModuleSdk(true);
        configuration.setModule(ModuleUtilCore.findModuleForPsiElement((PsiElement)element));
    }

    protected boolean setupConfigurationFromFunction(@NotNull PyFunction pyFunction, @NotNull AbstractPythonTestRunConfiguration configuration) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromFunction"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromFunction"));
        }
        PyClass containingClass = pyFunction.getContainingClass();
        configuration.setMethodName(pyFunction.getName());
        if (containingClass != null) {
            configuration.setClassName(containingClass.getName());
            configuration.setTestType(AbstractPythonTestRunConfiguration.TestType.TEST_METHOD);
        } else {
            configuration.setTestType(AbstractPythonTestRunConfiguration.TestType.TEST_FUNCTION);
        }
        return PythonTestConfigurationProducer.setupConfigurationScript(configuration, pyFunction);
    }

    protected boolean setupConfigurationFromClass(@NotNull PyClass pyClass, @NotNull AbstractPythonTestRunConfiguration configuration) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromClass"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromClass"));
        }
        configuration.setTestType(AbstractPythonTestRunConfiguration.TestType.TEST_CLASS);
        configuration.setClassName(pyClass.getName());
        return PythonTestConfigurationProducer.setupConfigurationScript(configuration, pyClass);
    }

    protected boolean setupConfigurationFromFile(@NotNull PyFile pyFile, @NotNull AbstractPythonTestRunConfiguration configuration) {
        if (pyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFile", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromFile"));
        }
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationFromFile"));
        }
        configuration.setTestType(AbstractPythonTestRunConfiguration.TestType.TEST_SCRIPT);
        return PythonTestConfigurationProducer.setupConfigurationScript(configuration, pyFile);
    }

    protected static boolean setupConfigurationScript(@NotNull AbstractPythonTestRunConfiguration cfg, @NotNull PyElement element) {
        if (cfg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cfg", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationScript"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "setupConfigurationScript"));
        }
        PyFile containingFile = PyUtil.getContainingPyFile(element);
        if (containingFile == null) {
            return false;
        }
        VirtualFile vFile = containingFile.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        VirtualFile parent = vFile.getParent();
        if (parent == null) {
            return false;
        }
        cfg.setScriptName(vFile.getPath());
        if (StringUtil.isEmptyOrSpaces((String)cfg.getWorkingDirectory())) {
            cfg.setWorkingDirectory(parent.getPath());
        }
        cfg.setGeneratedName();
        PythonTestConfigurationProducer.setModuleSdk((PsiElement)element, cfg);
        return true;
    }

    protected boolean isTestFolder(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        Module[] modules;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "isTestFolder"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "isTestFolder"));
        }
        String name = virtualFile.getName();
        HashSet roots = Sets.newHashSet();
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            roots.addAll(PyUtil.getSourceRoots(module));
        }
        Collections.addAll(roots, ProjectRootManager.getInstance((Project)project).getContentRoots());
        return name.toLowerCase().contains("test") || roots.contains(virtualFile);
    }

    protected boolean isAvailable(@NotNull Location location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "isAvailable"));
        }
        return false;
    }

    protected boolean isTestClass(@NotNull PyClass pyClass, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyClass", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "isTestClass"));
        }
        return PythonUnitTestUtil.isTestCaseClass(pyClass);
    }

    protected boolean isTestFunction(@NotNull PyFunction pyFunction, @Nullable AbstractPythonTestRunConfiguration configuration) {
        if (pyFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFunction", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "isTestFunction"));
        }
        return PythonUnitTestUtil.isTestCaseFunction(pyFunction);
    }

    protected boolean isTestFile(@NotNull PyFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "isTestFile"));
        }
        List<PyStatement> testCases = this.getTestCaseClassesFromFile(file);
        return !testCases.isEmpty();
    }

    protected static boolean isPythonModule(Module module) {
        Facet[] allFacets;
        if (module == null) {
            return false;
        }
        if (ModuleType.get((Module)module) instanceof PythonModuleTypeBase) {
            return true;
        }
        for (Facet facet : allFacets = FacetManager.getInstance((Module)module).getAllFacets()) {
            if (!(facet.getConfiguration() instanceof PythonFacetSettings)) continue;
            return true;
        }
        return false;
    }

    protected List<PyStatement> getTestCaseClassesFromFile(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pyFile", "com/jetbrains/python/testing/PythonTestConfigurationProducer", "getTestCaseClassesFromFile"));
        }
        return PythonUnitTestUtil.getTestCaseClassesFromFile(pyFile);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        RunConfiguration configuration = self.getConfiguration();
        if (configuration instanceof PythonUnitTestRunConfiguration && ((PythonUnitTestRunConfiguration)configuration).getTestType() == AbstractPythonTestRunConfiguration.TestType.TEST_FOLDER) {
            return true;
        }
        return other.isProducedBy(PythonTestConfigurationProducer.class) || other.isProducedBy(PythonRunConfigurationProducer.class);
    }
}

