/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.google.common.collect.Lists;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunConfiguration;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.CommandLinePatcher;
import com.jetbrains.python.run.PythonCommandLineState;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.AbstractPythonTestRunConfiguration;
import com.jetbrains.python.testing.PyRerunFailedTestsAction;
import com.jetbrains.python.testing.PythonTRunnerConsoleProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PythonTestCommandLineStateBase
extends PythonCommandLineState {
    protected final AbstractPythonRunConfiguration myConfiguration;

    public AbstractPythonRunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public PythonTestCommandLineStateBase(AbstractPythonRunConfiguration configuration, ExecutionEnvironment env) {
        super(configuration, env);
        this.myConfiguration = configuration;
    }

    @Override
    @NotNull
    protected ConsoleView createAndAttachConsole(Project project, ProcessHandler processHandler, Executor executor) throws ExecutionException {
        PythonTRunnerConsoleProperties consoleProperties = this.createConsoleProperties(executor);
        if (this.isDebug()) {
            BaseTestsOutputConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole("PythonUnitTestRunner", consoleProperties, this.getEnvironment());
            PythonDebugLanguageConsoleView consoleView = new PythonDebugLanguageConsoleView(project, PythonSdkType.findSdkByPath(this.myConfiguration.getInterpreterPath()), testsOutputConsoleView);
            consoleView.attachToProcess(processHandler);
            PythonDebugLanguageConsoleView pythonDebugLanguageConsoleView = consoleView;
            if (pythonDebugLanguageConsoleView == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonTestCommandLineStateBase", "createAndAttachConsole"));
            }
            return pythonDebugLanguageConsoleView;
        }
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createAndAttachConsole("PythonUnitTestRunner", processHandler, consoleProperties, this.getEnvironment());
        this.addTracebackFilter(project, consoleView, processHandler);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/testing/PythonTestCommandLineStateBase", "createAndAttachConsole"));
        }
        return baseTestsOutputConsoleView;
    }

    protected PythonTRunnerConsoleProperties createConsoleProperties(Executor executor) {
        return new PythonTRunnerConsoleProperties((ModuleRunConfiguration)this.myConfiguration, executor, false);
    }

    @Override
    public GeneralCommandLine generateCommandLine() throws ExecutionException {
        GeneralCommandLine cmd = super.generateCommandLine();
        this.setWorkingDirectory(cmd);
        ParamsGroup exe_options = cmd.getParametersList().getParamsGroup("Exe Options");
        assert (exe_options != null);
        exe_options.addParametersString(this.myConfiguration.getInterpreterOptions());
        this.addTestRunnerParameters(cmd);
        return cmd;
    }

    protected void setWorkingDirectory(@NotNull GeneralCommandLine cmd) {
        if (cmd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cmd", "com/jetbrains/python/testing/PythonTestCommandLineStateBase", "setWorkingDirectory"));
        }
        String workingDirectory = this.myConfiguration.getWorkingDirectory();
        if (!StringUtil.isEmptyOrSpaces((String)workingDirectory)) {
            cmd.setWorkDirectory(workingDirectory);
        } else if (this.myConfiguration instanceof AbstractPythonTestRunConfiguration) {
            String folderName = ((AbstractPythonTestRunConfiguration)this.myConfiguration).getFolderName();
            if (!StringUtil.isEmptyOrSpaces((String)folderName)) {
                cmd.setWorkDirectory(folderName);
            } else {
                String scriptName = ((AbstractPythonTestRunConfiguration)this.myConfiguration).getScriptName();
                if (StringUtil.isEmptyOrSpaces((String)scriptName)) {
                    return;
                }
                VirtualFile script = LocalFileSystem.getInstance().findFileByPath(scriptName);
                if (script == null) {
                    return;
                }
                cmd.setWorkDirectory(script.getParent().getPath());
            }
        }
    }

    @Override
    public ExecutionResult execute(Executor executor, CommandLinePatcher ... patchers) throws ExecutionException {
        ProcessHandler processHandler = this.startProcess(patchers);
        final ConsoleView console = this.createAndAttachConsole(this.myConfiguration.getProject(), processHandler, executor);
        ArrayList actions = Lists.newArrayList((Object[])this.createActions(console, processHandler));
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)console, processHandler, actions.toArray(new AnAction[actions.size()]));
        PyRerunFailedTestsAction rerunFailedTestsAction = new PyRerunFailedTestsAction((ComponentContainer)console);
        if (console instanceof SMTRunnerConsoleView) {
            rerunFailedTestsAction.init(((BaseTestsOutputConsoleView)console).getProperties());
            rerunFailedTestsAction.setModelProvider(new Getter<TestFrameworkRunningModel>(){

                public TestFrameworkRunningModel get() {
                    return ((SMTRunnerConsoleView)console).getResultsViewer();
                }
            });
        }
        executionResult.setRestartActions(new AnAction[]{rerunFailedTestsAction, new ToggleAutoTestAction(this.getEnvironment())});
        return executionResult;
    }

    protected void addBeforeParameters(GeneralCommandLine cmd) throws ExecutionException {
    }

    protected void addAfterParameters(GeneralCommandLine cmd) throws ExecutionException {
    }

    protected void addTestRunnerParameters(GeneralCommandLine cmd) throws ExecutionException {
        ParamsGroup script_params = cmd.getParametersList().getParamsGroup("Script");
        assert (script_params != null);
        script_params.addParameter(new File(PythonHelpersLocator.getHelpersRoot(), this.getRunner()).getAbsolutePath());
        this.addBeforeParameters(cmd);
        script_params.addParameters(this.getTestSpecs());
        this.addAfterParameters(cmd);
    }

    @Override
    public void addPredefinedEnvironmentVariables(Map<String, String> envs, boolean passParentEnvs) {
        super.addPredefinedEnvironmentVariables(envs, passParentEnvs);
        envs.put("PYCHARM_HELPERS_DIR", PythonHelpersLocator.getHelperPath("pycharm"));
    }

    protected abstract String getRunner();

    protected abstract List<String> getTestSpecs();
}

