/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonModuleTypeBase;
import com.jetbrains.python.documentation.PyDocumentationSettings;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.testing.PythonTestConfigurationsModel;
import com.jetbrains.python.testing.TestRunnerService;
import com.jetbrains.python.testing.VFSTestFrameworkListener;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyTestRunnerUpdater
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/testing/PyTestRunnerUpdater", "runActivity"));
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            return;
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            if (!(ModuleType.get((Module)m) instanceof PythonModuleTypeBase)) continue;
            PyTestRunnerUpdater.updateIntegratedTools(m, 10000);
            break;
        }
    }

    private static void updateIntegratedTools(final Module module, final int delay) {
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                if (delay > 0) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Sdk sdk;
                        TestRunnerService runnerService = TestRunnerService.getInstance(module);
                        if (runnerService == null) {
                            return;
                        }
                        String configuration = runnerService.getProjectConfiguration();
                        if (!StringUtil.isEmptyOrSpaces((String)configuration)) {
                            return;
                        }
                        String testRunner = PyTestRunnerUpdater.detectTestRunnerFromSetupPy(module);
                        Collection<VirtualFile> filenames = FilenameIndex.getAllFilesByExt(module.getProject(), PythonFileType.INSTANCE.getDefaultExtension(), GlobalSearchScope.moduleScope((Module)module));
                        for (VirtualFile file : filenames) {
                            if (file.getName().startsWith("test")) {
                                if (testRunner.isEmpty()) {
                                    testRunner = PyTestRunnerUpdater.checkImports(file, module);
                                }
                            } else if (PyDocumentationSettings.getInstance(module).getFormat().isEmpty()) {
                                PyTestRunnerUpdater.checkDocstring(file, module);
                            }
                            if (testRunner.isEmpty() || PyDocumentationSettings.getInstance(module).getFormat().isEmpty()) continue;
                            break;
                        }
                        if (testRunner.isEmpty() && (sdk = PythonSdkType.findPythonSdk(module)) != null && sdk.getSdkType() instanceof PythonSdkType && testRunner.isEmpty()) {
                            Boolean nose = VFSTestFrameworkListener.isTestFrameworkInstalled(sdk, "nose");
                            Boolean pytest = VFSTestFrameworkListener.isTestFrameworkInstalled(sdk, "pytest");
                            Boolean attest = VFSTestFrameworkListener.isTestFrameworkInstalled(sdk, "Attest");
                            if (nose != null && nose.booleanValue()) {
                                testRunner = PythonTestConfigurationsModel.PYTHONS_NOSETEST_NAME;
                            } else if (pytest != null && pytest.booleanValue()) {
                                testRunner = PythonTestConfigurationsModel.PY_TEST_NAME;
                            } else if (attest != null && attest.booleanValue()) {
                                testRunner = PythonTestConfigurationsModel.PYTHONS_ATTEST_NAME;
                            }
                        }
                        if (StringUtil.isEmptyOrSpaces((String)testRunner)) {
                            testRunner = PythonTestConfigurationsModel.PYTHONS_UNITTEST_NAME;
                        }
                        runnerService.setProjectConfiguration(testRunner);
                        if (PyDocumentationSettings.getInstance(module).getFormat().isEmpty()) {
                            PyDocumentationSettings.getInstance(module).setFormat("Plain");
                        }
                    }
                }, ModalityState.any(), module.getDisposed());
            }
        });
    }

    private static String detectTestRunnerFromSetupPy(Module module) {
        String testRunner = "";
        if (!testRunner.isEmpty()) {
            return testRunner;
        }
        PyFile setupPy = PyPackageUtil.findSetupPy(module);
        if (setupPy == null) {
            return testRunner;
        }
        PyCallExpression setupCall = PyPackageUtil.findSetupCall(setupPy);
        if (setupCall == null) {
            return testRunner;
        }
        for (PyExpression arg : setupCall.getArguments()) {
            PyExpression value;
            PyKeywordArgument kwarg;
            if (!(arg instanceof PyKeywordArgument) || !"test_loader".equals((kwarg = (PyKeywordArgument)arg).getKeyword()) && !"test_suite".equals(kwarg.getKeyword()) || !((value = kwarg.getValueExpression()) instanceof PyStringLiteralExpression)) continue;
            String stringValue = ((PyStringLiteralExpression)value).getStringValue();
            if (stringValue.contains("nose")) {
                testRunner = PythonTestConfigurationsModel.PYTHONS_NOSETEST_NAME;
                break;
            }
            if (stringValue.contains("pytest")) {
                testRunner = PythonTestConfigurationsModel.PY_TEST_NAME;
                break;
            }
            if (!stringValue.contains("attest")) continue;
            testRunner = PythonTestConfigurationsModel.PYTHONS_ATTEST_NAME;
            break;
        }
        return testRunner;
    }

    private static void checkDocstring(VirtualFile file, Module module) {
        PyDocumentationSettings documentationSettings = PyDocumentationSettings.getInstance(module);
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (psiFile instanceof PyFile) {
            if (documentationSettings.isEpydocFormat(psiFile)) {
                documentationSettings.setFormat("Epytext");
            } else if (documentationSettings.isReSTFormat(psiFile)) {
                documentationSettings.setFormat("reStructuredText");
            } else {
                String fileText = psiFile.getText();
                if (!(fileText.contains(":param ") || fileText.contains(":type ") || fileText.contains(":rtype ") || fileText.contains("@param ") || fileText.contains("@type ") || fileText.contains("@rtype "))) {
                    return;
                }
                PyDocStringOwner[] childrens = (PyDocStringOwner[])PsiTreeUtil.getChildrenOfType((PsiElement)psiFile, PyDocStringOwner.class);
                if (childrens != null) {
                    for (PyDocStringOwner owner : childrens) {
                        PyStringLiteralExpression docStringExpression = owner.getDocStringExpression();
                        if (docStringExpression == null) continue;
                        String text = docStringExpression.getStringValue();
                        if (text.contains(":param ") || text.contains(":rtype") || text.contains(":type")) {
                            documentationSettings.setFormat("reStructuredText");
                            return;
                        }
                        if (!text.contains("@param ") && !text.contains("@rtype") && !text.contains("@type")) continue;
                        documentationSettings.setFormat("Epytext");
                        return;
                    }
                }
            }
        }
    }

    private static String checkImports(VirtualFile file, Module module) {
        PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(file);
        if (psiFile instanceof PyFile) {
            List<PyImportElement> importTargets = ((PyFile)psiFile).getImportTargets();
            for (PyImportElement importElement : importTargets) {
                if ("nose".equals(importElement.getVisibleName())) {
                    return PythonTestConfigurationsModel.PYTHONS_NOSETEST_NAME;
                }
                if ("pytest".equals(importElement.getVisibleName())) {
                    return PythonTestConfigurationsModel.PY_TEST_NAME;
                }
                if (!"attest".equals(importElement.getVisibleName())) continue;
                return PythonTestConfigurationsModel.PYTHONS_ATTEST_NAME;
            }
        }
        return "";
    }
}

