/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import com.jetbrains.python.run.AbstractPythonRunConfigurationParams;
import com.jetbrains.python.testing.AbstractPythonTestRunConfigurationParams;
import java.io.File;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPythonTestRunConfiguration
extends AbstractPythonRunConfiguration
implements AbstractPythonRunConfigurationParams,
AbstractPythonTestRunConfigurationParams,
RefactoringListenerProvider {
    protected String myClassName = "";
    protected String myScriptName = "";
    protected String myMethodName = "";
    protected String myFolderName = "";
    protected TestType myTestType = TestType.TEST_SCRIPT;
    private String myPattern = "";
    private boolean usePattern = false;

    protected AbstractPythonTestRunConfiguration(Project project, ConfigurationFactory configurationFactory) {
        super(project, configurationFactory);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myScriptName = JDOMExternalizerUtil.readField((Element)element, (String)"SCRIPT_NAME");
        this.myClassName = JDOMExternalizerUtil.readField((Element)element, (String)"CLASS_NAME");
        this.myMethodName = JDOMExternalizerUtil.readField((Element)element, (String)"METHOD_NAME");
        this.myFolderName = JDOMExternalizerUtil.readField((Element)element, (String)"FOLDER_NAME");
        this.myPattern = JDOMExternalizerUtil.readField((Element)element, (String)"PATTERN");
        this.usePattern = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_PATTERN"));
        try {
            String testType = JDOMExternalizerUtil.readField((Element)element, (String)"TEST_TYPE");
            this.myTestType = testType != null ? TestType.valueOf(testType) : TestType.TEST_SCRIPT;
        }
        catch (IllegalArgumentException e) {
            this.myTestType = TestType.TEST_SCRIPT;
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        JDOMExternalizerUtil.writeField((Element)element, (String)"SCRIPT_NAME", (String)this.myScriptName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"CLASS_NAME", (String)this.myClassName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"METHOD_NAME", (String)this.myMethodName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"FOLDER_NAME", (String)this.myFolderName);
        JDOMExternalizerUtil.writeField((Element)element, (String)"TEST_TYPE", (String)this.myTestType.toString());
        JDOMExternalizerUtil.writeField((Element)element, (String)"PATTERN", (String)this.myPattern);
        JDOMExternalizerUtil.writeField((Element)element, (String)"USE_PATTERN", (String)String.valueOf(this.usePattern));
    }

    @Override
    public AbstractPythonRunConfigurationParams getBaseParams() {
        return this;
    }

    @Override
    public String getClassName() {
        return this.myClassName;
    }

    @Override
    public void setClassName(String className) {
        this.myClassName = className;
    }

    @Override
    public String getFolderName() {
        return this.myFolderName;
    }

    @Override
    public void setFolderName(String folderName) {
        this.myFolderName = folderName;
    }

    @Override
    public String getScriptName() {
        return this.myScriptName;
    }

    @Override
    public void setScriptName(String scriptName) {
        this.myScriptName = scriptName;
    }

    @Override
    public String getMethodName() {
        return this.myMethodName;
    }

    @Override
    public void setMethodName(String methodName) {
        this.myMethodName = methodName;
    }

    @Override
    public TestType getTestType() {
        return this.myTestType;
    }

    @Override
    public void setTestType(TestType testType) {
        this.myTestType = testType;
    }

    @Override
    public String getPattern() {
        return this.myPattern;
    }

    @Override
    public void setPattern(String pattern) {
        this.myPattern = pattern;
    }

    @Override
    public boolean usePattern() {
        return this.usePattern;
    }

    @Override
    public void usePattern(boolean usePattern) {
        this.usePattern = usePattern;
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        if (StringUtil.isEmptyOrSpaces((String)this.myFolderName) && this.myTestType == TestType.TEST_FOLDER) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_folder_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.getScriptName()) && this.myTestType != TestType.TEST_FOLDER) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_script_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myClassName) && (this.myTestType == TestType.TEST_METHOD || this.myTestType == TestType.TEST_CLASS)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_class_name", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myMethodName) && (this.myTestType == TestType.TEST_METHOD || this.myTestType == TestType.TEST_FUNCTION)) {
            throw new RuntimeConfigurationError(PyBundle.message("runcfg.unittest.no_method_name", new Object[0]));
        }
    }

    public boolean compareSettings(AbstractPythonTestRunConfiguration cfg) {
        if (cfg == null) {
            return false;
        }
        if (this.getTestType() != cfg.getTestType()) {
            return false;
        }
        switch (this.getTestType()) {
            case TEST_FOLDER: {
                return this.getFolderName().equals(cfg.getFolderName());
            }
            case TEST_SCRIPT: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory());
            }
            case TEST_CLASS: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getClassName().equals(cfg.getClassName());
            }
            case TEST_METHOD: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getClassName().equals(cfg.getClassName()) && this.getMethodName().equals(cfg.getMethodName());
            }
            case TEST_FUNCTION: {
                return this.getScriptName().equals(cfg.getScriptName()) && this.getWorkingDirectory().equals(cfg.getWorkingDirectory()) && this.getMethodName().equals(cfg.getMethodName());
            }
        }
        throw new IllegalStateException("Unknown test type: " + (Object)((Object)this.getTestType()));
    }

    public static void copyParams(AbstractPythonTestRunConfigurationParams source, AbstractPythonTestRunConfigurationParams target) {
        AbstractPythonRunConfiguration.copyParams(source.getBaseParams(), target.getBaseParams());
        target.setScriptName(source.getScriptName());
        target.setClassName(source.getClassName());
        target.setFolderName(source.getFolderName());
        target.setMethodName(source.getMethodName());
        target.setTestType(source.getTestType());
        target.setPattern(source.getPattern());
        target.usePattern(source.usePattern());
        target.setAddContentRoots(source.shouldAddContentRoots());
        target.setAddSourceRoots(source.shouldAddSourceRoots());
    }

    public AbstractPythonTestRunConfigurationParams getTestRunConfigurationParams() {
        return this;
    }

    public String suggestedName() {
        switch (this.myTestType) {
            case TEST_CLASS: {
                return this.getPluralTitle() + " in " + this.myClassName;
            }
            case TEST_METHOD: {
                return this.getTitle() + " " + this.myClassName + "." + this.myMethodName;
            }
            case TEST_SCRIPT: {
                String name = new File(this.getScriptName()).getName();
                if (name.endsWith(".py")) {
                    name = name.substring(0, name.length() - 3);
                }
                return this.getPluralTitle() + " in " + name;
            }
            case TEST_FOLDER: {
                String folderName = new File(this.myFolderName).getName();
                return this.getPluralTitle() + " in " + folderName;
            }
            case TEST_FUNCTION: {
                return this.getTitle() + " " + this.myMethodName;
            }
        }
        throw new IllegalStateException("Unknown test type: " + (Object)((Object)this.myTestType));
    }

    @Nullable
    public String getActionName() {
        if (TestType.TEST_METHOD.equals((Object)this.myTestType)) {
            return this.getTitle() + " " + this.myMethodName;
        }
        return this.suggestedName();
    }

    protected abstract String getTitle();

    protected abstract String getPluralTitle();

    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        PsiFile containingFile;
        VirtualFile vFile;
        if (element instanceof PsiDirectory) {
            VirtualFile vFile2 = ((PsiDirectory)element).getVirtualFile();
            if (this.myTestType == TestType.TEST_FOLDER && AbstractPythonTestRunConfiguration.pathsEqual(vFile2, this.myFolderName) || AbstractPythonTestRunConfiguration.pathsEqual(vFile2, this.getWorkingDirectory())) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$1", "elementRenamedOrMoved"));
                        }
                        String newPath = FileUtil.toSystemDependentName((String)((PsiDirectory)newElement).getVirtualFile().getPath());
                        AbstractPythonTestRunConfiguration.this.setWorkingDirectory(newPath);
                        if (AbstractPythonTestRunConfiguration.this.myTestType == TestType.TEST_FOLDER) {
                            AbstractPythonTestRunConfiguration.this.myFolderName = newPath;
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$1", "undoElementMovedOrRenamed"));
                        }
                        if (oldQualifiedName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$1", "undoElementMovedOrRenamed"));
                        }
                        String systemDependant = FileUtil.toSystemDependentName((String)oldQualifiedName);
                        AbstractPythonTestRunConfiguration.this.setWorkingDirectory(systemDependant);
                        if (AbstractPythonTestRunConfiguration.this.myTestType == TestType.TEST_FOLDER) {
                            AbstractPythonTestRunConfiguration.this.myFolderName = systemDependant;
                        }
                    }
                };
            }
            return null;
        }
        if (this.myTestType == TestType.TEST_FOLDER) {
            return null;
        }
        File scriptFile = new File(this.myScriptName);
        if (!scriptFile.isAbsolute()) {
            scriptFile = new File(this.getWorkingDirectory(), this.myScriptName);
        }
        VirtualFile virtualFile = vFile = (containingFile = element.getContainingFile()) == null ? null : containingFile.getVirtualFile();
        if (vFile != null && Comparing.equal((String)new File(vFile.getPath()).getAbsolutePath(), (String)scriptFile.getAbsolutePath())) {
            if (element instanceof PsiFile) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$2", "elementRenamedOrMoved"));
                        }
                        VirtualFile virtualFile = ((PsiFile)newElement).getVirtualFile();
                        if (virtualFile != null) {
                            AbstractPythonTestRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                        }
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$2", "undoElementMovedOrRenamed"));
                        }
                        if (oldQualifiedName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$2", "undoElementMovedOrRenamed"));
                        }
                        AbstractPythonTestRunConfiguration.this.myScriptName = FileUtil.toSystemDependentName((String)oldQualifiedName);
                    }
                };
            }
            if (element instanceof PyClass && (this.myTestType == TestType.TEST_CLASS || this.myTestType == TestType.TEST_METHOD) && Comparing.equal((String)((PyClass)element).getName(), (String)this.myClassName)) {
                return new RefactoringElementAdapter(){

                    protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$3", "elementRenamedOrMoved"));
                        }
                        AbstractPythonTestRunConfiguration.this.myClassName = ((PyClass)newElement).getName();
                    }

                    public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                        if (newElement == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$3", "undoElementMovedOrRenamed"));
                        }
                        if (oldQualifiedName == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$3", "undoElementMovedOrRenamed"));
                        }
                        AbstractPythonTestRunConfiguration.this.myClassName = oldQualifiedName;
                    }
                };
            }
            if (element instanceof PyFunction && Comparing.equal((String)((PyFunction)element).getName(), (String)this.myMethodName)) {
                ScopeOwner scopeOwner = (ScopeOwner)PsiTreeUtil.getParentOfType((PsiElement)element, ScopeOwner.class);
                if (this.myTestType == TestType.TEST_FUNCTION && scopeOwner instanceof PyFile || this.myTestType == TestType.TEST_METHOD && scopeOwner instanceof PyClass && Comparing.equal((String)scopeOwner.getName(), (String)this.myClassName)) {
                    return new RefactoringElementAdapter(){

                        protected void elementRenamedOrMoved(@NotNull PsiElement newElement) {
                            if (newElement == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$4", "elementRenamedOrMoved"));
                            }
                            AbstractPythonTestRunConfiguration.this.myMethodName = ((PyFunction)newElement).getName();
                        }

                        public void undoElementMovedOrRenamed(@NotNull PsiElement newElement, @NotNull String oldQualifiedName) {
                            if (newElement == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$4", "undoElementMovedOrRenamed"));
                            }
                            if (oldQualifiedName == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldQualifiedName", "com/jetbrains/python/testing/AbstractPythonTestRunConfiguration$4", "undoElementMovedOrRenamed"));
                            }
                            int methodIdx = oldQualifiedName.indexOf("#") + 1;
                            if (methodIdx > 0 && methodIdx < oldQualifiedName.length()) {
                                AbstractPythonTestRunConfiguration.this.myMethodName = oldQualifiedName.substring(methodIdx);
                            }
                        }
                    };
                }
            }
        }
        return null;
    }

    private static boolean pathsEqual(VirtualFile vFile, String folderName) {
        return Comparing.equal((String)new File(vFile.getPath()).getAbsolutePath(), (String)new File(folderName).getAbsolutePath());
    }

    public static enum TestType {
        TEST_FOLDER,
        TEST_SCRIPT,
        TEST_CLASS,
        TEST_METHOD,
        TEST_FUNCTION;

    }
}

