/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.python.templateLanguages.TemplateSettingsHolder;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class TemplateLanguagePanel
extends JPanel {
    private JTextField myTemplatesFolder;
    private JPanel myMainPanel;
    private JLabel myTemplatesFolderLabel;
    private JComboBox myTemplateLanguage;
    private boolean myTemplateFolderModified = false;
    private static final String DEFAULT_TEMPLATES_FOLDER = "templates";

    public TemplateLanguagePanel() {
        super(new BorderLayout());
        this.$$$setupUI$$$();
        this.add((Component)this.myMainPanel, "Center");
        this.myTemplatesFolderLabel.setLabelFor(this.myTemplatesFolder);
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.withTreeRootVisible(true);
        descriptor.setShowFileSystemRoots(true);
        List<String> templateConfigurations = TemplatesService.getAllTemplateLanguages();
        for (String configuration : templateConfigurations) {
            if (configuration.equals("Web2Py")) continue;
            this.myTemplateLanguage.addItem(configuration);
        }
        this.myTemplatesFolder.setText(DEFAULT_TEMPLATES_FOLDER);
        this.myTemplatesFolder.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                int dot = TemplateLanguagePanel.this.myTemplatesFolder.getCaret().getDot();
                int index = TemplateLanguagePanel.this.myTemplatesFolder.getText().indexOf(File.separator);
                if (index >= dot) {
                    TemplateLanguagePanel.this.myTemplateFolderModified = true;
                }
            }
        });
    }

    public String getTemplatesFolder() {
        return this.myTemplatesFolder.getText();
    }

    public String getTemplateLanguage() {
        Object selectedItem = this.myTemplateLanguage.getSelectedItem();
        return selectedItem != null ? (String)selectedItem : null;
    }

    public void setTemplateLanguage(String language) {
        this.myTemplateLanguage.setSelectedItem(language);
    }

    public void saveSettings(TemplateSettingsHolder holder) {
        holder.setTemplatesFolder(this.getTemplatesFolder());
        String templateLanguage = this.getTemplateLanguage();
        holder.setTemplateLanguage(templateLanguage);
    }

    public void setTemplatesFolder(@NotNull String folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/jetbrains/python/templateLanguages/TemplateLanguagePanel", "setTemplatesFolder"));
        }
        this.myTemplatesFolder.setText(folder);
    }

    public void locationChanged(@NotNull String baseLocation) {
        String oldBase;
        if (baseLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseLocation", "com/jetbrains/python/templateLanguages/TemplateLanguagePanel", "locationChanged"));
        }
        String templatesFolder = this.myTemplatesFolder.getText();
        int index = templatesFolder.indexOf(File.separator);
        String templateFolderName = index >= 0 ? templatesFolder.substring(index) : File.separator + DEFAULT_TEMPLATES_FOLDER;
        String string = oldBase = index >= 0 ? templatesFolder.substring(0, index) : "";
        if (oldBase.equals(baseLocation)) {
            this.myTemplateFolderModified = false;
        }
        if (!this.myTemplateFolderModified) {
            this.myTemplatesFolder.setText(baseLocation + templateFolderName);
        }
    }

    public Dimension getLabelSize() {
        return new JBLabel("Template language:").getPreferredSize();
    }

    public void registerValidators(final FacetValidatorsManager validatorsManager) {
        this.myTemplateLanguage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                validatorsManager.validate();
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myTemplateLanguage = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Template language:");
        jPanel.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplatesFolderLabel = jLabel = new JLabel();
        jLabel.setText("Templates folder:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myTemplatesFolder = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

