/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonStringUtil;
import com.jetbrains.python.templateLanguages.TemplateFileReference;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFileReferenceSet
extends FileReferenceSet {
    private final String mySeparatorString;

    public TemplateFileReferenceSet(@NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet", "<init>"));
        }
        this(TemplateFileReferenceSet.str(element), element, provider);
    }

    public TemplateFileReferenceSet(String text, @NotNull PsiElement element, @Nullable PsiReferenceProvider provider) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet", "<init>"));
        }
        super(text, element, TemplateFileReferenceSet.detectShift(element, text), provider, SystemInfo.isFileSystemCaseSensitive);
        this.mySeparatorString = TemplateFileReferenceSet.detectSeparator(element);
        this.reparse();
    }

    private static String str(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet", "str"));
        }
        return PythonStringUtil.stripQuotesAroundValue(element.getText());
    }

    public static int detectShift(PsiElement element, String text) {
        String elementText = element.getText();
        int from = 0;
        Pair<String, String> quotes = PythonStringUtil.getQuotes(elementText);
        if (quotes != null) {
            from = ((String)quotes.first).length();
        }
        return elementText.indexOf(text, from);
    }

    public static String detectSeparator(PsiElement element) {
        String winSeparator = PythonStringUtil.isRawString(element.getText()) ? "\\" : "\\\\";
        return TemplateFileReferenceSet.str(element).contains(winSeparator) ? winSeparator : "/";
    }

    @Override
    public String getSeparatorString() {
        if (this.mySeparatorString == null) {
            return super.getSeparatorString();
        }
        return this.mySeparatorString;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList contexts = ContainerUtil.newArrayList();
        if (this.getPathString().startsWith("/") || this.getPathString().startsWith("\\")) {
            ArrayList arrayList = contexts;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet", "computeDefaultContexts"));
            }
            return arrayList;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            List<VirtualFile> templatesFolders = this.getRoots(module);
            for (VirtualFile folder : templatesFolders) {
                PsiFileSystemItem directory = this.getPsiDirectory(module, folder);
                if (directory == null) continue;
                contexts.add(directory);
            }
        }
        ArrayList arrayList = contexts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/templateLanguages/TemplateFileReferenceSet", "computeDefaultContexts"));
        }
        return arrayList;
    }

    protected PsiFileSystemItem getPsiDirectory(Module module, VirtualFile folder) {
        return PsiManager.getInstance((Project)module.getProject()).findDirectory(folder);
    }

    protected List<VirtualFile> getRoots(Module module) {
        return TemplatesService.getInstance(module).getTemplateFolders();
    }

    @Override
    public FileReference createFileReference(TextRange range, int index, String text) {
        return new TemplateFileReference(this, range, index, text);
    }
}

