/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.WeakFileReference;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateFileReference
extends WeakFileReference {
    public TemplateFileReference(@NotNull FileReferenceSet fileReferenceSet, TextRange range, int index, String text) {
        if (fileReferenceSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileReferenceSet", "com/jetbrains/python/templateLanguages/TemplateFileReference", "<init>"));
        }
        super(fileReferenceSet, range, index, text);
    }

    @Override
    @Nullable
    public String getUnresolvedDescription() {
        return "Template file '" + this.getCanonicalText() + "' not found";
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element, boolean absolute) throws IncorrectOperationException {
        VirtualFile curVFile;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/templateLanguages/TemplateFileReference", "bindToElement"));
        }
        if (!(element instanceof PsiFileSystemItem)) {
            throw new IncorrectOperationException("Cannot bind to element, should be instanceof PsiFileSystemItem: " + element);
        }
        PsiFileSystemItem fileSystemItem = (PsiFileSystemItem)element;
        VirtualFile dstVFile = fileSystemItem.getVirtualFile();
        if (dstVFile == null) {
            throw new IncorrectOperationException("Cannot bind to non-physical element:" + element);
        }
        PsiFile file = this.getElement().getContainingFile();
        PsiLanguageInjectionHost contextPsiFile = InjectedLanguageManager.getInstance((Project)file.getProject()).getInjectionHost((PsiElement)file);
        if (contextPsiFile != null) {
            file = contextPsiFile.getContainingFile();
        }
        if ((curVFile = file.getVirtualFile()) == null) {
            throw new IncorrectOperationException("Cannot bind from non-physical element:" + file);
        }
        PsiFileSystemItem curItem = null;
        PsiFileSystemItem dstItem = null;
        PsiFileSystemItem _dstItem = FileReferenceHelper.getPsiFileSystemItem(file.getManager(), dstVFile);
        PsiFileSystemItem _curItem = FileReferenceHelper.getPsiFileSystemItem(file.getManager(), curVFile);
        if (_dstItem != null && _curItem != null) {
            curItem = _curItem;
            dstItem = _dstItem;
        }
        Collection<PsiFileSystemItem> contexts = this.getContexts();
        switch (contexts.size()) {
            case 0: {
                break;
            }
            default: {
                for (PsiFileSystemItem context : contexts) {
                    String path;
                    VirtualFile contextFile = context.getVirtualFile();
                    assert (contextFile != null);
                    if (!VfsUtil.isAncestor((VirtualFile)contextFile, (VirtualFile)dstVFile, (boolean)true) || (path = VfsUtilCore.getRelativePath((VirtualFile)dstVFile, (VirtualFile)contextFile, (char)'/')) == null) continue;
                    return this.rename(path.replace("/", this.getFileReferenceSet().getSeparatorString()));
                }
            }
        }
        if (curItem == null) {
            throw new IncorrectOperationException("Cannot find path between files; src = " + curVFile.getPresentableUrl() + "; " + "dst = " + dstVFile.getPresentableUrl() + "; " + "Contexts: " + contexts);
        }
        if (curItem.equals(dstItem)) {
            if (this.getCanonicalText().equals(dstItem.getName())) {
                return this.getElement();
            }
            return ElementManipulators.getManipulator((PsiElement)this.getElement()).handleContentChange(this.getElement(), this.getRangeInElement(), file.getName());
        }
        String newName = PsiFileSystemItemUtil.getRelativePath(curItem, dstItem);
        if (newName == null) {
            return this.getElement();
        }
        return this.rename(newName);
    }
}

