/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.execution.ExecutionException;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.templateLanguages.TemplateLanguagePanel;
import com.jetbrains.python.templateLanguages.TemplatesService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTemplatesUtil {
    private PyTemplatesUtil() {
    }

    public static ValidationResult checkInstalled(@Nullable Sdk sdk, @NotNull TemplateLanguagePanel templatesPanel, @NotNull String prefix) {
        PyPackage installedPackage;
        if (templatesPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templatesPanel", "com/jetbrains/python/templateLanguages/PyTemplatesUtil", "checkInstalled"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/jetbrains/python/templateLanguages/PyTemplatesUtil", "checkInstalled"));
        }
        if (sdk == null) {
            return ValidationResult.OK;
        }
        String templateBinding = null;
        String language = templatesPanel.getTemplateLanguage();
        if (language != null) {
            if (language.equals("Jinja2")) {
                language = "jinja";
            }
            templateBinding = prefix + language.toLowerCase();
        }
        PyPackageManager packageManager = PyPackageManager.getInstance(sdk);
        if (templateBinding != null && TemplatesService.ALL_TEMPLATE_BINDINGS.contains(templateBinding)) {
            try {
                installedPackage = packageManager.findPackage(templateBinding, false);
                if (installedPackage == null) {
                    return new ValidationResult(templateBinding + " will be installed on selected interpreter");
                }
            }
            catch (ExecutionException ignored) {
                // empty catch block
            }
        }
        if (language != null) {
            try {
                installedPackage = packageManager.findPackage(language, false);
                if (installedPackage == null) {
                    return new ValidationResult(language + " will be installed on selected interpreter");
                }
            }
            catch (ExecutionException ignored) {
                // empty catch block
            }
        }
        return null;
    }
}

