/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.templateLanguages;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralFileReferenceSet;
import com.jetbrains.python.templateLanguages.TemplateFileReference;
import com.jetbrains.python.templateLanguages.TemplateFileReferenceSet;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyTemplateFileReferenceSet
extends PyStringLiteralFileReferenceSet {
    public PyTemplateFileReferenceSet(PyStringLiteralExpression element) {
        super(element, false);
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> computeDefaultContexts() {
        ArrayList contexts = ContainerUtil.newArrayList();
        if (this.getPathString().startsWith("/") || this.getPathString().startsWith("\\")) {
            ArrayList arrayList = contexts;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/templateLanguages/PyTemplateFileReferenceSet", "computeDefaultContexts"));
            }
            return arrayList;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
        if (module != null) {
            List<VirtualFile> templatesFolders = this.getRoots(module);
            for (VirtualFile folder : templatesFolders) {
                PsiDirectory directory = PsiManager.getInstance((Project)module.getProject()).findDirectory(folder);
                if (directory == null) continue;
                contexts.add(directory);
            }
        }
        ArrayList arrayList = contexts;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/templateLanguages/PyTemplateFileReferenceSet", "computeDefaultContexts"));
        }
        return arrayList;
    }

    @Override
    public String getSeparatorString() {
        return TemplateFileReferenceSet.detectSeparator(this.getElement());
    }

    protected List<VirtualFile> getRoots(Module module) {
        return TemplatesService.getInstance(module).getTemplateFolders();
    }

    @Override
    public FileReference createFileReference(TextRange range, int index, String text) {
        return new TemplateFileReference(this, range, index, text);
    }
}

