/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyPackageUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "py-packages";

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/statistics/PyPackageUsagesCollector", "getProjectUsages"));
        }
        final HashSet<UsageDescriptor> result = new HashSet<UsageDescriptor>();
        for (final Module m : ModuleManager.getInstance((Project)project).getModules()) {
            final Sdk pythonSdk = PythonSdkType.findPythonSdk(m);
            if (pythonSdk == null) continue;
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    List<PyRequirement> requirements = PyPackageManager.getInstance(pythonSdk).getRequirements(m);
                    if (requirements != null) {
                        HashSet<String> packages = new HashSet<String>(PyPIPackageUtil.INSTANCE.getPackageNames());
                        for (PyRequirement requirement : requirements) {
                            String name = requirement.getName();
                            if (!packages.contains(name)) continue;
                            result.add(new UsageDescriptor(name, 1));
                        }
                    }
                }
            });
        }
        HashSet<UsageDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/statistics/PyPackageUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/statistics/PyPackageUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

