/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PyInterpreterUsagesCollector
extends AbstractApplicationUsagesCollector {
    private static final String GROUP_ID = "py-interpreter";

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) throws CollectUsagesException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/python/statistics/PyInterpreterUsagesCollector", "getProjectUsages"));
        }
        HashSet<UsageDescriptor> result = new HashSet<UsageDescriptor>();
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            String versionString;
            Sdk pythonSdk = PythonSdkType.findPythonSdk(m);
            if (pythonSdk == null || (versionString = pythonSdk.getVersionString()) == null) continue;
            result.add(new UsageDescriptor(versionString, 1));
        }
        HashSet<UsageDescriptor> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/statistics/PyInterpreterUsagesCollector", "getProjectUsages"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create(GROUP_ID);
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/statistics/PyInterpreterUsagesCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

