/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PythonSpellcheckerStrategy
extends SpellcheckingStrategy {
    private StringLiteralTokenizer myStringLiteralTokenizer = new StringLiteralTokenizer();
    private FormatStringTokenizer myFormatStringTokenizer = new FormatStringTokenizer();

    @Override
    @NotNull
    public Tokenizer getTokenizer(PsiElement element) {
        if (element instanceof PyStringLiteralExpression) {
            PyBinaryExpression binaryExpression;
            PsiElement parent = element.getParent();
            if (parent instanceof PyBinaryExpression && element == (binaryExpression = (PyBinaryExpression)parent).getLeftExpression() && binaryExpression.getOperator() == PyTokenTypes.PERC) {
                FormatStringTokenizer formatStringTokenizer = this.myFormatStringTokenizer;
                if (formatStringTokenizer == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy", "getTokenizer"));
                }
                return formatStringTokenizer;
            }
            StringLiteralTokenizer stringLiteralTokenizer = this.myStringLiteralTokenizer;
            if (stringLiteralTokenizer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy", "getTokenizer"));
            }
            return stringLiteralTokenizer;
        }
        Tokenizer tokenizer = super.getTokenizer(element);
        if (tokenizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy", "getTokenizer"));
        }
        return tokenizer;
    }

    private static class FormatStringTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private FormatStringTokenizer() {
        }

        @Override
        public void tokenize(@NotNull PyStringLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$FormatStringTokenizer", "tokenize"));
            }
            String stringValue = element.getStringValue();
            List<PyStringFormatParser.FormatStringChunk> chunks = PyStringFormatParser.parsePercentFormat(stringValue);
            PlainTextSplitter splitter = PlainTextSplitter.getInstance();
            for (PyStringFormatParser.FormatStringChunk chunk : chunks) {
                if (!(chunk instanceof PyStringFormatParser.ConstantChunk)) continue;
                int startIndex = element.valueOffsetToTextOffset(chunk.getStartIndex());
                int endIndex = element.valueOffsetToTextOffset(chunk.getEndIndex());
                String text = element.getText().substring(startIndex, endIndex);
                consumer.consumeToken(element, text, false, startIndex, TextRange.allOf((String)text), splitter);
            }
        }
    }

    private static class StringLiteralTokenizer
    extends Tokenizer<PyStringLiteralExpression> {
        private StringLiteralTokenizer() {
        }

        @Override
        public void tokenize(@NotNull PyStringLiteralExpression element, TokenConsumer consumer) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/python/spellchecker/PythonSpellcheckerStrategy$StringLiteralTokenizer", "tokenize"));
            }
            PlainTextSplitter splitter = PlainTextSplitter.getInstance();
            String text = element.getText();
            if (text.indexOf(92) >= 0) {
                for (Pair<TextRange, String> fragment : element.getDecodedFragments()) {
                    String value = (String)fragment.getSecond();
                    consumer.consumeToken(element, value, false, ((TextRange)fragment.getFirst()).getStartOffset(), TextRange.allOf((String)value), PlainTextSplitter.getInstance());
                }
            } else if (text.startsWith("u") || text.startsWith("U") || text.startsWith("r") || text.startsWith("R") || text.startsWith("b") || text.startsWith("B")) {
                List<TextRange> valueTextRanges = element.getStringValueTextRanges();
                for (TextRange valueTextRange : valueTextRanges) {
                    int startOffset = valueTextRange.getStartOffset();
                    consumer.consumeToken(element, valueTextRange.substring(element.getText()), false, startOffset, valueTextRange.shiftRight(-startOffset), splitter);
                }
            } else {
                consumer.consumeToken(element, splitter);
            }
        }
    }
}

