/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.spellchecker.PythonSpellcheckerDictionaryGenerator;

public class PythonSpellcheckerGenerateDictionariesAction
extends AnAction {
    public void actionPerformed(AnActionEvent e) {
        VirtualFile[] roots;
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (module == null) {
            return;
        }
        VirtualFile[] contentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
        if (contentRoots.length == 0) {
            return;
        }
        Sdk sdk = PythonSdkType.findPythonSdk(module);
        if (sdk == null) {
            return;
        }
        PythonSpellcheckerDictionaryGenerator generator = new PythonSpellcheckerDictionaryGenerator(module.getProject(), contentRoots[0].getPath() + "/dicts");
        for (VirtualFile root : roots = sdk.getRootProvider().getFiles(OrderRootType.CLASSES)) {
            VirtualFile djangoRoot;
            if (root.getName().equals("Lib")) {
                generator.addFolder("python", root);
                generator.excludeFolder(root.findChild("test"));
                generator.excludeFolder(root.findChild("site-packages"));
                continue;
            }
            if (!root.getName().equals("site-packages") || (djangoRoot = root.findChild("django")) == null) continue;
            generator.addFolder("django", djangoRoot);
        }
        generator.generate();
    }
}

