/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.IronPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.sdk.skeletons.PySkeletonRefresher;
import com.jetbrains.python.sdk.skeletons.SkeletonVersionChecker;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonGenerator {
    private static final Map<Class<? extends PythonSdkFlavor>, String> ENV_PATH_PARAM = new HashMap<Class<? extends PythonSdkFlavor>, String>();
    protected static final Logger LOG;
    protected static final int MINUTE = 60000;
    protected static final String GENERATOR3 = "generator3.py";
    private final String mySkeletonsPath;
    @NotNull
    private final Map<String, String> myEnv;

    public void finishSkeletonsGeneration() {
    }

    public boolean exists(String name) {
        return new File(name).exists();
    }

    public PySkeletonGenerator(String skeletonPath, @NotNull Sdk pySdk, @Nullable String currentFolder) {
        if (pySdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pySdk", "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator", "<init>"));
        }
        this.mySkeletonsPath = skeletonPath;
        PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(pySdk);
        this.myEnv = currentFolder != null && flavor != null && ENV_PATH_PARAM.containsKey(flavor.getClass()) ? ImmutableMap.of((Object)ENV_PATH_PARAM.get(flavor.getClass()), (Object)currentFolder) : Collections.emptyMap();
    }

    public String getSkeletonsPath() {
        return this.mySkeletonsPath;
    }

    public void prepare() {
    }

    protected void generateSkeleton(String modname, String modfilename, List<String> assemblyRefs, String syspath, String sdkHomePath, Consumer<Boolean> resultConsumer) throws InvalidSdkException {
        ProcessOutput genResult = this.runSkeletonGeneration(modname, modfilename, assemblyRefs, sdkHomePath, syspath);
        if (genResult.getStderrLines().size() > 0) {
            StringBuilder sb = new StringBuilder("Skeleton for ");
            sb.append(modname);
            if (genResult.getExitCode() != 0) {
                sb.append(" failed on ");
            } else {
                sb.append(" had some minor errors on ");
            }
            sb.append(sdkHomePath).append(". stderr: --\n");
            for (String err_line : genResult.getStderrLines()) {
                sb.append(err_line).append("\n");
            }
            sb.append("--");
            if (ApplicationManagerEx.getApplicationEx().isInternal()) {
                LOG.warn(sb.toString());
            } else {
                LOG.info(sb.toString());
            }
        }
        resultConsumer.consume((Object)(genResult.getExitCode() == 0 ? 1 : 0));
    }

    public ProcessOutput runSkeletonGeneration(String modname, String modfilename, List<String> assemblyRefs, String binaryPath, String extraSyspath) throws InvalidSdkException {
        Map<String, String> extraEnv;
        String parent_dir = new File(binaryPath).getParent();
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(binaryPath);
        commandLine.add(PythonHelpersLocator.getHelperPath(GENERATOR3));
        commandLine.add("-d");
        commandLine.add(this.getSkeletonsPath());
        if (assemblyRefs != null && !assemblyRefs.isEmpty()) {
            commandLine.add("-c");
            commandLine.add(StringUtil.join(assemblyRefs, (String)";"));
        }
        if (ApplicationManagerEx.getApplicationEx().isInternal()) {
            commandLine.add("-x");
        }
        if (!StringUtil.isEmpty((String)extraSyspath)) {
            commandLine.add("-s");
            commandLine.add(extraSyspath);
        }
        commandLine.add(modname);
        if (modfilename != null) {
            commandLine.add(modfilename);
        }
        Map<String, String> env = (extraEnv = PythonSdkType.getVirtualEnvExtraEnv(binaryPath)) != null ? PySdkUtil.mergeEnvVariables(this.myEnv, extraEnv) : this.myEnv;
        return this.getProcessOutput(parent_dir, ArrayUtil.toStringArray(commandLine), env, 600000);
    }

    protected ProcessOutput getProcessOutput(String homePath, String[] commandLine, Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        return PySdkUtil.getProcessOutput(homePath, commandLine, extraEnv, timeout);
    }

    public void generateBuiltinSkeletons(@NotNull Sdk sdk) throws InvalidSdkException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator", "generateBuiltinSkeletons"));
        }
        new File(this.mySkeletonsPath).mkdirs();
        String binaryPath = sdk.getHomePath();
        if (binaryPath == null) {
            throw new InvalidSdkException("Broken home path for " + sdk.getName());
        }
        long startTime = System.currentTimeMillis();
        ProcessOutput runResult = this.getProcessOutput(new File(binaryPath).getParent(), new String[]{binaryPath, PythonHelpersLocator.getHelperPath(GENERATOR3), "-d", this.mySkeletonsPath, "-b"}, PythonSdkType.getVirtualEnvExtraEnv(binaryPath), 300000);
        runResult.checkSuccess(LOG);
        LOG.info("Rebuilding builtin skeletons took " + (System.currentTimeMillis() - startTime) + " ms");
    }

    @NotNull
    public ListBinariesResult listBinaries(@NotNull Sdk sdk, @NotNull String extraSysPath) throws InvalidSdkException {
        if (sdk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator", "listBinaries"));
        }
        if (extraSysPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraSysPath", "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator", "listBinaries"));
        }
        String homePath = sdk.getHomePath();
        long startTime = System.currentTimeMillis();
        if (homePath == null) {
            throw new InvalidSdkException("Broken home path for " + sdk.getName());
        }
        String parentDir = new File(homePath).getParent();
        ArrayList<String> cmd = new ArrayList<String>(Arrays.asList(homePath, PythonHelpersLocator.getHelperPath(GENERATOR3), "-v", "-L"));
        if (!StringUtil.isEmpty((String)extraSysPath)) {
            cmd.add("-s");
            cmd.add(extraSysPath);
        }
        ProcessOutput process = this.getProcessOutput(parentDir, ArrayUtil.toStringArray(cmd), PythonSdkType.getVirtualEnvExtraEnv(homePath), 240000);
        LOG.info("Retrieving binary module list took " + (System.currentTimeMillis() - startTime) + " ms");
        if (process.getExitCode() != 0) {
            StringBuilder sb = new StringBuilder("failed to run ").append(GENERATOR3).append(" for ").append(homePath);
            if (process.isTimeout()) {
                sb.append(": timed out.");
            } else {
                sb.append(", exit code ").append(process.getExitCode()).append(", stderr: \n-----\n");
                for (String line : process.getStderrLines()) {
                    sb.append(line).append("\n");
                }
                sb.append("-----");
            }
            throw new InvalidSdkException(sb.toString());
        }
        List lines = process.getStdoutLines();
        if (lines.size() < 1) {
            throw new InvalidSdkException("Empty output from generator3.py for " + homePath);
        }
        Iterator iter = lines.iterator();
        int generatorVersion = SkeletonVersionChecker.fromVersionString(((String)iter.next()).trim());
        HashMap binaries = Maps.newHashMap();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            int cutpos = line.indexOf(9);
            if (cutpos >= 0) {
                String[] strs = line.split("\t");
                String moduleName = strs[0];
                String path = strs[1];
                int length = Integer.parseInt(strs[2]);
                int lastModified = Integer.parseInt(strs[3]);
                binaries.put(moduleName, new PySkeletonRefresher.PyBinaryItem(moduleName, path, length, lastModified));
                continue;
            }
            LOG.error("Bad binaries line: '" + line + "', SDK " + homePath);
        }
        ListBinariesResult listBinariesResult = new ListBinariesResult(generatorVersion, binaries);
        if (listBinariesResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator", "listBinaries"));
        }
        return listBinariesResult;
    }

    public boolean deleteOrLog(@NotNull File item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/jetbrains/python/sdk/skeletons/PySkeletonGenerator", "deleteOrLog"));
        }
        boolean deleted = item.delete();
        if (!deleted) {
            LOG.warn("Failed to delete skeleton file " + item.getAbsolutePath());
        }
        return deleted;
    }

    public void refreshGeneratedSkeletons() {
        VirtualFile skeletonsVFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.getSkeletonsPath());
        assert (skeletonsVFile != null);
        skeletonsVFile.refresh(false, true);
    }

    static {
        ENV_PATH_PARAM.put(IronPythonSdkFlavor.class, "IRONPYTHONPATH");
        LOG = Logger.getInstance((String)("#" + PySkeletonGenerator.class.getName()));
    }

    public static class ListBinariesResult {
        public final int generatorVersion;
        public final Map<String, PySkeletonRefresher.PyBinaryItem> modules;

        public ListBinariesResult(int generatorVersion, Map<String, PySkeletonRefresher.PyBinaryItem> modules) {
            this.generatorVersion = generatorVersion;
            this.modules = modules;
        }
    }
}

