/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.WindowsRegistryUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class WinPythonSdkFlavor
extends CPythonSdkFlavor {
    public static WinPythonSdkFlavor INSTANCE = new WinPythonSdkFlavor();
    private static Map<String, String> ourRegistryMap = ImmutableMap.of((Object)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Python\\PythonCore", (Object)"python.exe", (Object)"HKEY_LOCAL_MACHINE\\SOFTWARE\\Wow6432Node\\Python\\PythonCore", (Object)"python.exe", (Object)"HKEY_LOCAL_MACHINE\\SOFTWARE\\IronPython", (Object)"ipy.exe");
    private static Set<String> ourRegistryCache;

    private WinPythonSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths() {
        TreeSet<String> candidates = new TreeSet<String>();
        WinPythonSdkFlavor.findInCandidatePaths(candidates, "python.exe", "jython.bat", "pypy.exe");
        WinPythonSdkFlavor.findInstallations(candidates, "python.exe", PythonHelpersLocator.getHelpersRoot().getParent());
        return candidates;
    }

    private static void findInCandidatePaths(Set<String> candidates, String ... exe_names) {
        for (String name : exe_names) {
            WinPythonSdkFlavor.findInstallations(candidates, name, "C:\\", "C:\\Program Files\\");
            WinPythonSdkFlavor.findInPath(candidates, name);
            WinPythonSdkFlavor.findInRegistry(candidates);
        }
    }

    private static void findInstallations(Set<String> candidates, String exe_name, String ... roots) {
        for (String root : roots) {
            WinPythonSdkFlavor.findSubdirInstallations(candidates, root, FileUtil.getNameWithoutExtension((String)exe_name), exe_name);
        }
    }

    public static void findInPath(Collection<String> candidates, String exeName) {
        String path = System.getenv("PATH");
        if (path == null) {
            return;
        }
        for (String pathEntry : StringUtil.split((String)path, (String)";")) {
            File f;
            if (pathEntry.startsWith("\"") && pathEntry.endsWith("\"")) {
                if (pathEntry.length() < 2) continue;
                pathEntry = pathEntry.substring(1, pathEntry.length() - 1);
            }
            if (!(f = new File(pathEntry, exeName)).exists()) continue;
            candidates.add(FileUtil.toSystemDependentName((String)f.getPath()));
        }
    }

    public static void findInRegistry(Collection<String> candidates) {
        WinPythonSdkFlavor.fillRegistryCache();
        candidates.addAll(ourRegistryCache);
    }

    private static void fillRegistryCache() {
        if (ourRegistryCache == null) {
            ourRegistryCache = new HashSet<String>();
            for (Map.Entry<String, String> entry : ourRegistryMap.entrySet()) {
                String prefix = entry.getKey();
                String exePath = entry.getValue();
                List strings = WindowsRegistryUtil.readRegistryBranch((String)prefix);
                for (String string : strings) {
                    File f;
                    String path = WindowsRegistryUtil.readRegistryDefault((String)(prefix + "\\" + string + "\\InstallPath"));
                    if (path == null || !(f = new File(path, exePath)).exists()) continue;
                    ourRegistryCache.add(FileUtil.toSystemDependentName((String)f.getPath()));
                }
            }
        }
    }

    private static void findSubdirInstallations(Collection<String> candidates, String rootDir, String dir_prefix, String exe_name) {
        VirtualFile rootVDir = LocalFileSystem.getInstance().findFileByPath(rootDir);
        if (rootVDir != null) {
            if (rootVDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootVDir).markDirty();
            }
            rootVDir.refresh(true, false);
            for (VirtualFile dir : rootVDir.getChildren()) {
                VirtualFile python_exe;
                if (!dir.isDirectory() || !dir.getName().toLowerCase().startsWith(dir_prefix) || (python_exe = dir.findChild(exe_name)) == null) continue;
                candidates.add(FileUtil.toSystemDependentName((String)python_exe.getPath()));
            }
        }
    }
}

