/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import icons.PythonIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualEnvSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"jython", "pypy", "python.exe", "jython.bat", "pypy.exe"};
    public static VirtualEnvSdkFlavor INSTANCE = new VirtualEnvSdkFlavor();

    private VirtualEnvSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths() {
        VirtualFile path;
        VirtualFile rootDir;
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        ArrayList<String> candidates = new ArrayList<String>();
        if (project != null && (rootDir = project.getBaseDir()) != null) {
            candidates.addAll(VirtualEnvSdkFlavor.findInDirectory(rootDir));
        }
        if ((path = VirtualEnvSdkFlavor.getDefaultLocation()) != null) {
            candidates.addAll(VirtualEnvSdkFlavor.findInDirectory(path));
        }
        return candidates;
    }

    @Nullable
    public static VirtualFile getDefaultLocation() {
        String path = System.getenv().get("WORKON_HOME");
        if (!StringUtil.isEmpty((String)path)) {
            return LocalFileSystem.getInstance().findFileByPath(FileUtil.expandUserHome((String)path).replace('\\', '/'));
        }
        VirtualFile userHome = LocalFileSystem.getInstance().findFileByPath(SystemProperties.getUserHome().replace('\\', '/'));
        if (userHome != null) {
            VirtualFile predefinedFolder = userHome.findChild(".virtualenvs");
            if (predefinedFolder == null) {
                return userHome;
            }
            return predefinedFolder;
        }
        return null;
    }

    public static Collection<String> findInDirectory(VirtualFile rootDir) {
        ArrayList<String> candidates = new ArrayList<String>();
        if (rootDir != null) {
            VirtualFile[] suspects;
            rootDir.refresh(true, false);
            for (VirtualFile child : suspects = rootDir.getChildren()) {
                String interpreter;
                if (!child.isDirectory()) continue;
                VirtualFile bin = child.findChild("bin");
                VirtualFile scripts = child.findChild("Scripts");
                if (bin != null && (interpreter = VirtualEnvSdkFlavor.findInterpreter(bin)) != null) {
                    candidates.add(interpreter);
                }
                if (scripts == null || (interpreter = VirtualEnvSdkFlavor.findInterpreter(scripts)) == null) continue;
                candidates.add(interpreter);
            }
        }
        return candidates;
    }

    @Nullable
    private static String findInterpreter(VirtualFile dir) {
        for (VirtualFile child : dir.getChildren()) {
            if (child.isDirectory()) continue;
            String childName = child.getName().toLowerCase();
            for (String name : NAMES) {
                if (SystemInfo.isWindows) {
                    if (!childName.equals(name)) continue;
                    return FileUtil.toSystemDependentName((String)child.getPath());
                }
                if (!childName.startsWith(name) && !PYTHON_RE.matcher(childName).matches() || childName.endsWith("-config")) continue;
                return child.getPath();
            }
        }
        return null;
    }

    @Override
    public boolean isValidSdkPath(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/python/sdk/flavors/VirtualEnvSdkFlavor", "isValidSdkPath"));
        }
        if (!super.isValidSdkPath(file)) {
            return false;
        }
        return PythonSdkType.getVirtualEnvRoot(file.getPath()) != null;
    }

    @Override
    public Icon getIcon() {
        return PythonIcons.Python.Virtualenv;
    }
}

