/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.flavors;

import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.containers.HashSet;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import java.util.Collection;
import java.util.Set;

public class UnixPythonSdkFlavor
extends CPythonSdkFlavor {
    private static final String[] NAMES = new String[]{"jython", "pypy"};
    public static UnixPythonSdkFlavor INSTANCE = new UnixPythonSdkFlavor();

    private UnixPythonSdkFlavor() {
    }

    @Override
    public Collection<String> suggestHomePaths() {
        HashSet candidates = new HashSet();
        UnixPythonSdkFlavor.collectUnixPythons("/usr/bin", (Set<String>)candidates);
        return candidates;
    }

    public static void collectUnixPythons(String path, Set<String> candidates) {
        VirtualFile rootDir = LocalFileSystem.getInstance().findFileByPath(path);
        if (rootDir != null) {
            VirtualFile[] suspects;
            if (rootDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootDir).markDirty();
            }
            rootDir.refresh(true, false);
            block0: for (VirtualFile child : suspects = rootDir.getChildren()) {
                if (child.isDirectory()) continue;
                String childName = child.getName().toLowerCase();
                for (String name : NAMES) {
                    if (!childName.startsWith(name) && !PYTHON_RE.matcher(childName).matches()) continue;
                    String childPath = child.getPath();
                    if (FileSystemUtil.isSymLink((String)childPath)) {
                        childPath = FileSystemUtil.resolveSymLink((String)childPath);
                    }
                    if (childPath == null || childName.endsWith("-config") || childName.startsWith("pythonw") || childName.endsWith("m") || candidates.contains(childPath)) continue block0;
                    candidates.add(childPath);
                    continue block0;
                }
            }
        }
    }
}

